; NINO BRUNORI OCTOBER 1, 2025
; THIS TOOK A LOT OF MAN-HOURS AND HARD WORK; I DO NOT EXPECT YOU TO PROFIT OFF IT, AND THE CREDIT SHOULD GO WHERE IT IS DUE.
; I HAVE SEEN A LOT OF PEOPLE'S HARD WORK PASS TO HISTORY WHILE OTHERS BOOST THEIR OWN STATS.
; IT'S BEEN OVER 40 YEARS SINCE CP/M 2.2 HAS BEEN RELEASED, AND NO ONE HAS RELEASED THE SOURCE, SO HERE YOU GO.
; EDUCATE YOURSELF, PATCH IT FOR 3.0 OR WHATEVER YOU WANT, BUT AGAIN, I TOOK A LONG TIME IN PREPPING THIS BEFORE RELEASE.


DATA_PORT:              EQU $00BE
CTRL_PORT:              EQU $00BF
SOUND_PORT:             EQU $00FF
KEYBOARD_PORT:          EQU $0080
MEM_PORT:               EQU $007F

DCB_TEMP_SP:            EQU $FC91
DCB_SAVE_DSP:           EQU $FC92

; ---- SCREEN BUFFER ----
;SCREEN_BUFFER_START: EQU $F477           ; START OF SCREEN BUFFER (ROW_00)
ROW_00:                 EQU $F477
ROW_01:                 EQU $F4C7
ROW_02:                 EQU $F517
ROW_03:                 EQU $F567
ROW_04:                 EQU $F5B7
ROW_05:                 EQU $F607
ROW_06:                 EQU $F657
ROW_07:                 EQU $F6A7
ROW_08:                 EQU $F6F7
ROW_09:                 EQU $F747
ROW_10:                 EQU $F797
ROW_11:                 EQU $F7E7
ROW_12:                 EQU $F837
ROW_13:                 EQU $F887
ROW_14:                 EQU $F8D7
ROW_15:                 EQU $F927
ROW_16:                 EQU $F977
ROW_17:                 EQU $F9C7
ROW_18:                 EQU $FA17
ROW_19:                 EQU $FA67
ROW_20:                 EQU $FAB7
ROW_21:                 EQU $FB07
ROW_22:                 EQU $FB57
LAST_ROW_START:         EQU $FBA6
ROW_23:                 EQU $FBA7
LAST_ROW_END:           EQU $FBF6

CONSOLE_BUFFER_END:     EQU $FBF7
FKEY_TEXT_BUFFER_1:     EQU $FBF8
FKEY_TEXT_PAD_END:      EQU $FC02
FKEY_TEXT_PAD_START:    EQU $FC03
FKEY_TEXT_BUFFER_2:     EQU $FC08
FKEY_RENDER_COUNTER:    EQU $FC17
FKEY_RENDER_PTR:        EQU $FC18
FKEY_HANDLER_DEFAULT:   EQU $FC1A
WORD_FC20:              EQU $FC20
UNK_FC22:               EQU $FC22
UNK_FC5D:               EQU $FC5D
UNK_FC5E:               EQU $FC5E
UNK_FEC3:               EQU $FEC3
UNK_FED4:               EQU $FED4
UNK_FFF0:               EQU $FFF0

JP_WARM_BOOT:           EQU $00
BDOS_JMP2:              EQU $01
BDOS_JMP3:              EQU $06
IOBYTE:                 EQU $03               ;I/O DEFINITION BYTE.
TDRIVE:                 EQU $04               ;CURRENT DRIVE NAME AND USER NUMBER.
ENTRY:                  EQU $05               ;ENTRY POINT FOR THE CP/M BDOS.
TBASE:                  EQU $100              ;TRANSIANT PROGRAM STORAGE AREA.

SMART_WRITER_ASCII:     EQU $304              ; BEGINING OF ASCII TABLE TO TRANSFER FROM SMART WRITER

RESTART_7:              EQU $38
FKEY_ADDRESS:           EQU $40
FKEY_DESCRIPT:          EQU $42
FKEY_STUFF_C:           EQU $44
FKEY_MACRO_PTR:         EQU $46
IS_RAM_DISK_THERE:      EQU $4D
BOOT_DEVICE_ID:         EQU $4F


FNAME "ADAM CPM 2.2 BIOS.BIN"
CPU Z80

    ORG $DA00


    JP      BOOT
WBOOTE:
    JP      WARM_BOOT
    JP      CONSOLE_STATUS
    JP      CONSOLE_INPUT
    JP      CONSOLE_OUTPUT
    JP      PRINTER_OUTPUT
    JP      PUNCH_OUTPUT
    JP      READER_INPUT
    JP      HOME_DISK
    JP      SELECT_DISK
    JP      SELECT_TRACK
    JP      SELECT_SECTOR
    JP      SELECT_DMA
    JP      READ
    JP      WRITE
    JP      LIST_STATUS
    JP      HOME_DISK
    JP      FUTURE_USE
    JP      FUTURE_USE
    JP      FUTURE_USE
    JP      FUTURE_USE
    JP      FUTURE_USE
    JP      FUTURE_USE
    JP      FUTURE_USE
    JP      FUTURE_USE
    JP      FUTURE_USE
    JP      FUTURE_USE
    JP      FUTURE_USE
    JP      FUTURE_USE
    JP      FLUSH_CONSOLE_INPUT
    JP      VRAM_FILL
    JP      VRAM_WRITE
    JP      VRAM_READ
    JP      WRITE_VDP_REG
    JP      INIT_VDP
    JP      AUX_WRITE
    JP      AUX_READ
    JP      AUX_OUT_STATUS
    JP      AUX_IN_STATUS
_INIT_AUX_DEVICE:
    JP      INIT_AUX_DEVICE
    JP      READ1BLOCK
    JP      WRITE1BLOCK
    JP      FUTURE_USE
    JP      FUTURE_USE
    JP      FUTURE_USE
    JP      FUTURE_USE
_WILDCARD_CONTINUE:
    JP      WILDCARD_CONTINUE
    CALL    DISPLAY_SCREEN

SIGNON:
    LD      HL,  CPM_WELCOME_MESSAGE_TXT+6CH

DISPLAY_SCREEN:
    LD      C, (HL)
    INC     C
    DEC     C
    RET     Z
    INC     HL
    PUSH    HL
    CALL    DISPLAY_CHARACTER
    POP     HL
    JR      DISPLAY_SCREEN

BOOT:
    LD      SP, $C000
    CALL    SETUP_FKEY_VARS
    CALL    INIT_VDP
    LD      HL, DEVICE_INIT_PARAMS
    CALL    _INIT_AUX_DEVICE
    LD      A, 81H
    LD      (IOBYTE), A
    LD      HL, ADAM_GRAPHIC_DATA
    CALL    DISPLAY_SCREEN
    LD      HL, CPM_WELCOME_MESSAGE_TXT
    CALL    DISPLAY_SCREEN
INIT_DRIVE_ZERO:
    XOR     A
    LD      (TDRIVE), A
WARM_BOOT:
    LD      C, 0
    CALL    INIT_CPM_KERNEL
    LD      SP, 80H
    XOR     A
    LD      HL, DRIVE_NUM
    LD      (HL), A
    LD      D, H
    LD      E, L
    INC     DE
    LD      BC, 9
    LDIR
    INC     DE
    INC     DE
    LD      (DE), A
    LD      (DRIVE_INIT_FLAG), A
    LD      DE, $C200
    LD      BC, 7
    LD      A, 6
READ_BOOT_LOOP:
    PUSH    AF
    PUSH    BC
    PUSH    DE
    LD      A, (CURRENT_DRIVE)
    CALL    READ1BLOCK
    JR      NC, PATCH_JUMP_VECTORS
    POP     DE
    POP     BC
    POP     AF
    LD      HL, 400H
    ADD     HL, DE
    EX      DE, HL
    INC     BC
    DEC     A
    JR      NZ, READ_BOOT_LOOP
    CALL    KEYBOARD_HANDLE_EDGE_CASE
    CALL    FLUSH_CONSOLE_INPUT
    LD      BC, 80H
    CALL    SELECT_DMA
    LD      A, 0C3H
    LD      (JP_WARM_BOOT), A
    LD      (ENTRY), A
    LD      HL, WBOOTE
    LD      (BDOS_JMP2), HL
    LD      HL, $CC06
    LD      (BDOS_JMP3), HL
    LD      HL, $C400
    LD      A, (HL)
    CP      0C3H
    JR      NZ, PATCH_JUMP_VECTORS
    LD      A, (TDRIVE)
    LD      C, A
    JP      (HL)
PATCH_JUMP_VECTORS:
    LD      HL, BAD_SYSTEM_TXT
    CALL    DISPLAY_SCREEN
    CALL    FLUSH_CONSOLE_INPUT
    CALL    FLUSH_CONSOLE_INIT
    JP      INIT_DRIVE_ZERO

SETUP_FKEY_VARS:
    LD      DE, 40H 
    LD      HL, FKEY_ADJUST_STACK
    LD      B, D
    LD      C, 8
    LDIR
FUTURE_USE:
RET

BAD_SYSTEM_TXT:
	DB $0D,$0A
	db 'Bad System, Retry On A:',0

ADAM_GRAPHIC_DATA:
	DB  1Ah, 1Bh, 59h, 21h, 24h, 1Ch, 80h, 81h, 82h, 83h, 84h, 85h, 86h, 87h, 88h, 89h, 8Ah, 8Bh, 8Ch, 8Dh
    DB  8Eh, 8Fh, 90h, 91h, 87h, 88h, 89h, 92h, 0Dh, 0Ah, 1Dh, 20h, 20h, 20h, 20h, 80h, 81h, 82h, 83h, 84h
    DB  85h, 86h, 87h, 88h, 89h, 8Ah, 8Bh, 8Ch, 8Dh, 8Eh, 8Fh, 90h, 91h, 87h, 88h, 89h, 0Dh, 0Ah, 0Ah,   0
CPM_WELCOME_MESSAGE_TXT:
	DB 9,'  CP/M 2.2'
	DB $0D,$0A
	DB '(c) Digital Research 1976,1984'
	DB $0D,$0A,$0A,$0A
	DB '       Welcome to CP/M'
	DB $0D,$0A,$0A
	DB '   Wait till prompt appears.'
	DB $0D,$0A
	DB $0A,$0A,$0A,$0A,$0A,$0A
CRLF:
	DB  $0D,$0A,0

CONSOLE_IN_TABLE:
	DW AUX_READ
    DW KEYBOARD_WAIT_FOR_INPUT
    DW 0
    DW KEYBOARD_WAIT_FOR_INPUT
    DW AUX_WRITE
    DW PUT_CHAR_AT_CURSOR
    DW 0
    DW PUT_CHAR_AT_CURSOR
    DW AUX_READ
    DW KEYBOARD_WAIT_FOR_INPUT
    DW KEYBOARD_WAIT_FOR_INPUT
    DW KEYBOARD_WAIT_FOR_INPUT
    DW AUX_WRITE
    DW PUT_CHAR_AT_CURSOR
    DW PUT_CHAR_AT_CURSOR
    DW PUT_CHAR_AT_CURSOR
    DW AUX_WRITE
    DW PUT_CHAR_AT_CURSOR
    DW AUX_WRITE_2BYTE_INIT
    DW AUX_WRITE_2BYTE_INIT
CONSOLE_STATUS_TABLE:
	DW AUX_IN_STATUS
    DW KEYBOARD_CHECK_READY
    DW 0
    DW KEYBOARD_CHECK_READY
    DW AUX_OUT_STATUS
    DW KEYBOARD_RETURN_WITH_CARRY
    DW 0
    DW KEYBOARD_RETURN_WITH_CARRY
    DW AUX_IN_STATUS
    DW KEYBOARD_CHECK_READY
    DW KEYBOARD_CHECK_READY
    DW KEYBOARD_CHECK_READY
    DW AUX_OUT_STATUS
    DW KEYBOARD_RETURN_WITH_CARRY
    DW KEYBOARD_RETURN_WITH_CARRY
    DW KEYBOARD_RETURN_WITH_CARRY
    DW AUX_OUT_STATUS
    DW KEYBOARD_RETURN_WITH_CARRY
KEYBOARD_MACRO_TABLE:
	DW KEYBOARD_PROBE_STATUS_LATCH+1
    DW KEYBOARD_PROBE_STATUS_LATCH+1
KEYBOARD_INPUT_BYTE:
	DB    0, 8EH, 8DH, 8CH, 8BH, 8AH, 89H, 86H, 85H, 84H, 83H, 82H, 81H,   9
    DB 0AFH,0AEH,0ADH,0ACH,0ABH,0AAH,0A9H,0A8H,0A6H, 13H, 18H,   4,   5, 9FH ; SYMBOL TABLE (UPPERCASE, UNDERSCORE FORMAT)
    DB  9EH, 9DH, 9CH, 9BH, 9AH, 98H, 97H, 96H, 95H, 94H, 93H, 92H, 91H, 90H
WORD_DC84: 
	DW 1880H
    DW 1514H
CURSOR_LEFT_BOUNDARY:
	DB    0
UNK_DC89:
	DB    5
KEYBOARD_READY_FLAG:
	DB    0
BYTE_DC8B: 
	DB 0FFH
CHAR_INPUT_MODE_FLAG:
	DB 0
BYTE_DC8D:   
	DB 0
CURSOR_SPR_ATTRIBUTES:
	DB    3,   3,   0,   5,0D0H
CURSOR_SPR_PATTERN:
	DB    0,   0,   0,   0,   0,   0,0FEH,0FEH
VDP_COLOR_TABLE_2:
	DB 1
VDP_COLOR_TABLE_1:
	DB 10H
FUNCTION_KEY_TEXT_A:
	DB $20, $44, $49, $52, $20 ; ' DIR '
	DB $20, $20, $20, $20, $20
	DB $20, $45, $52, $41, $20 ; ' ERA '
	DB $20, $20, $20, $20, $20
	DB $20, $52, $45, $4E, $20 ; ' REN '
	DB $20, $20, $20, $20, $20
	DB $20, $55, $53, $45, $52 ; ' USER'
	DB $20, $20, $20, $20, $20
	DB $20, $53, $41, $56, $45 ; ' SAVE'
	DB $20, $20, $20, $20, $20
	DB $20, $54, $59, $50, $45 ; ' TYPE'
	DB $20, $20, $20, $20, $20
	; This data contains the text strings assigned to the function keys.

FUNCTION_KEY_TEXT_B:
	DB $44, $49, $52, $20, $00 ; 'DIR ' followed by NULL termination
	DB $00, $00, $00, $00, $00
	DB $00, $00, $00, $00, $00
	DB $00, $45, $52, $41, $20 ; 'ERA ' followed by NULLs
	DB $00, $00, $00, $00, $00
	DB $00, $00, $00, $00, $00
	DB $00, $00, $52, $45, $4E ; 'REN' followed by NULLs
	DB $20, $00, $00, $00, $00
	DB $00, $00, $00, $00, $00
	DB $00, $00, $00, $55, $53 ; 'USER' followed by NULLs
	DB $45, $52, $20, $00, $00
	DB $00, $00, $00, $00, $00
	DB $00, $00, $00, $00, $53 ; 'SAVE' followed by NULLs
	DB $41, $56, $45, $20, $00
	DB $00, $00, $00, $00, $00
	DB $00, $00, $00, $00, $00
	DB $54, $59, $50, $45, $20 ; 'TYPE' followed by NULLs
	DB $00, $00, $00, $00, $00
	DB $00, $00, $00, $00, $00
	DB $00
DEVICE_ID_TABLE:
	DW  0000H, 01FFH,0FF01H, 0202H, 03FFH,0FF03H, 0404H, 05FFH,0FF05H
DEVICE_INIT_PARAMS:
	DW 305H
    DW 2
    DW 102H
KEYBOARD_SCAN_MAP:
	DB  59H, 48H, 4AH, 4BH, 62H, 63H, 6AH, 6BH, 6DH, 6EH, 6FH
    DB  70H, 71H, 41H, 42H, 43H, 44H, 45H, 49H, 3AH, 69H, 6CH ; POSSIBLE COMMAND CODES FOR ESC-???
DISPATCH_TABLE:
	DW SOME_TABLE_00
    DW MOVE_CURSOR_DOWN_HELPER
    DW MOVE_TO_BEGINNING_OF_LINE
    DW SCROLL_UP
    DW MOVE_CURSOR_LEFT
    DW MOVE_CURSOR_RIGHT
    DW MOVE_CURSOR_UP
    DW BEEP_SOUND
    DW CURSOR_LEFT_WRAP_HANDLER
    DW MOVE_CURSOR_LEFT_BOUNDARY_HELPER
    DW FKEY_HANDLER_07
    DW RESTORE_DEVICE_HANDLER
    DW CURSOR_CONTROL_HANDLER
    DW DEVICE_RESET_HANDLER
    DW CURSOR_CONTROL_HANDLER+1
    DW DEALS_WITH_ROW_HELPER+1
    DW FKEY_HANDLER_15
    DW FKEY_HANDLER_15+1
    DW FKEY_HANDLER_05
    DW FKEY_HANDLER_05+1
    DW CURSOR_LEFT_BOUNDARY_DEC
    DW CURSOR_LEFT_BOUNDARY_INC
    DW FKEY_HANDLER_ROW_21
    DW FKEY_HANDLER_CONTROL_01
    DW FKEY_HANDLER_ENTRY_09
    DW FKEY_HANDLER_ENTRY_04
    DW FKEY_HANDLER_ENTRY_08
    DW FKEY_HANDLER_CHAIN_ENTRY_24
    DW FKEY_HANDLER_25
    DW FKEY_HANDLER_26+1
    DW SCROLL_DOWN
    DW HANDLE_ROW_SCROLLING
UNK_DDA7:
	DB    8
    DB    0
    DB    3
    DB    7
    DB    0
    DB 0F2H
    DB    0
    DB  3FH 
    DB    0
    DB 0C0H
    DB    0
    DB  10H
    DB    0
    DB  0DH
    DB    0
DISK_INIT_TABLE:
	DB    8
    DB    0
    DB    3
    DB    7
    DB    0
    DB  92H
    DB    0
    DB  3FH 
    DB    0
    DB 0C0H
    DB    0
    DB  10H
    DB    0
    DB  0DH
    DB    0
UNK_DDC5:
	DB    8
    DB    0
    DB    3
    DB    7
    DB    0
    DB  37H
    DB    0
    DB  1FH
    DB    0
    DB  80H
    DB    0
    DB    8
    DB    0
    DB    0
    DB    0
DRIVE_DESCRIPTOR_TABLE:
	DW 0
    DW 0
    DW 0
    DW 0
    DW BUFFER_01
    DW UNK_DDA7
    DW BUFFER_02
    DW BUFFER_07
    DW 0
    DW 0
    DW 0
    DW 0
    DW BUFFER_01
    DW UNK_DDA7
    DW BUFFER_03
    DW BUFFER_08
    DW 0
    DW 0
    DW 0
    DW 0
    DW BUFFER_01
    DW DISK_INIT_TABLE
    DW BUFFER_04
    DW BUFFER_09
    DW 0
    DW 0
    DW 0
    DW 0
    DW BUFFER_01
    DW DISK_INIT_TABLE
    DW BUFFER_05
    DW BUFFER_10
UNK_DE14:
	DB    0
    DB    0
    DB    0
    DB    0
    DB    0
    DB    0
    DB    0
    DB    0
    DW BUFFER_01
    DW UNK_DDC5
    DW BUFFER_06
    DW BUFFER_11

INIT_VDP:
    CALL    VDP_SETUP_REGISTERS
    RLCA
    RLCA
    LD      (HL), C
    INC     BC
    RST     38H
    LD      B, 80H
    LD      (BC), A
    CALL    FILL_VDP_COLOR_TABLES
    XOR     A
	OUT     (MEM_PORT), A
    LD      HL, ($102)
    CALL    GET_ASCII_FROM_SMARTWRITER
    LD      A, 1
	OUT     (MEM_PORT), A
    LD      HL, CURSOR_SPR_PATTERN
    LD      DE, 3800H       ; SPRITE?
    LD      BC, 8
    CALL    VRAM_WRITE
    LD      HL, CURSOR_SPR_ATTRIBUTES
    LD      DE, 3880H       ; SPRITE?
    LD      BC, 5
    CALL    VRAM_WRITE
    LD      A, 20H     ; CLEAR SCREEN
    LD      DE, 1800H       ; NAME TABLE
    LD      BC, 300H
    CALL    VRAM_FILL
    LD      C, 0CH
    CALL    PUT_CHAR_AT_CURSOR
    CALL    INIT_SMARTKEY_UI
    CALL    FKEY_TOGGLE_HANDLER+1
    LD      DE, 0
    LD      BC, 98H
    LD      HL, LOGO_1_PAT
    CALL    VRAM_WRITE
    LD      DE, 400H
    LD      BC, 90H
    LD      HL, LOGO_2_PAT
    CALL    VRAM_WRITE
    LD      A, 40H 
    LD      BC, 98H
    LD      DE, 2000H       ; COLOR
    CALL    VRAM_FILL
    LD      BC, 90H
    LD      DE, 2400H       ; COLOR
    CALL    VRAM_FILL
    LD      DE, 1C0H

WRITE_VDP_REG:
    SET     7, D
    JR      SET_VRAM_WRITE_ADDRESS

SET_VRAM_WRITE_BIT:
    SET     6, D
SET_VRAM_WRITE_ADDRESS:
    LD      A, E
	OUT     (0BFH), A
    LD      A, D
    NOP
	OUT     (0BFH), A
RET

VDP_SETUP_REGISTERS:
    POP     HL
    LD      B, 7
SETUP_REG_LOOP:
    LD      D, B
    LD      E, (HL)
    CALL    WRITE_VDP_REG
    INC     HL
    DEC     B
    JP      P, SETUP_REG_LOOP
    JP      (HL)

FILL_VDP_COLOR_TABLES:
    LD      A, (VDP_COLOR_TABLE_1)
    EX      AF, AF'
    LD      A, (VDP_COLOR_TABLE_2)
    LD      B, 6
    LD      DE, 2000H
    LD      C, A
    EX      AF, AF'
COLOR_FILL_LOOP:
    PUSH    AF
    PUSH    BC
    LD      BC, 400H
    PUSH    BC
    PUSH    DE
    CALL    VRAM_FILL
    POP     HL
    POP     BC
    ADD     HL, BC
    EX      DE, HL
    POP     BC
    LD      A, C
    EX      AF, AF'
    POP     AF
    LD      C, A
    EX      AF, AF'
    DJNZ    COLOR_FILL_LOOP
RET

GET_ASCII_FROM_SMARTWRITER:
    LD      BC, 400H
    LD      DE, 0
SEND_TO_VRAM_LOOP:
    PUSH    HL
    PUSH    DE
    PUSH    BC
    CALL    VRAM_WRITE
    POP     BC
    POP     HL
    POP     DE
    ADD     HL, BC
    LD      A, 18H
    CP      H
    EX      DE, HL
    JR      NZ, SEND_TO_VRAM_LOOP
RET

FILL_SMARTKEY_REGION:
    EX      AF, AF'
    CALL    SET_VRAM_WRITE_BIT
    EX      AF, AF'
VRAM_FILL_PATTERN_LOOP:
	OUT     (0BEH), A
    INC     A
    NOP
    NOP
    DJNZ    VRAM_FILL_PATTERN_LOOP
RET

VRAM_READ:
    EX      DE, HL
    CALL    SET_VRAM_WRITE_ADDRESS
    LD      A, B
    LD      B, C
    LD      C, 0BEH
    INC     A
    INC     B
    DEC     B
VRAM_READ_DELAY_LOOP:
    LD      DE, $A2ED
    NOP
    NOP
    JR      NZ, VRAM_READ_DELAY_LOOP+1
    DEC     A
    JR      NZ, VRAM_READ_DELAY_LOOP+1
RET

VRAM_WRITE:
    CALL    SET_VRAM_WRITE_BIT

SMARTKEY_TIMING_LOOP:
    LD      A, B
    LD      B, C
    LD      C, 0BEH
    INC     A
    INC     B
    DEC     B
SMARTKEY_DELAY_LOOP:
    LD      DE, $A3ED       ; DUMMY ADDRESS (NOT ACCESSED)
    NOP
    NOP
    JR      NZ, SMARTKEY_DELAY_LOOP+1 ; DUMMY ADDRESS (NOT ACCESSED)
    DEC     A
    JR      NZ, SMARTKEY_DELAY_LOOP+1 ; DUMMY ADDRESS (NOT ACCESSED)
RET

VRAM_FILL:
    EX      AF, AF'
    CALL    SET_VRAM_WRITE_BIT
    EX      AF, AF'
    INC     B
    INC     C

VRAM_FILL_LOOP:
    LD      DE, $BED3       ; DUMMY ADDRESS (NOT ACCESSED)
    NOP
    DEC     C
    JR      NZ, VRAM_FILL_LOOP+1 ; DUMMY ADDRESS (NOT ACCESSED)
    DJNZ    VRAM_FILL_LOOP+1 ; DUMMY ADDRESS (NOT ACCESSED)
RET

INIT_SMARTKEY_UI:
    XOR     A
    LD      B, 1EH
    LD      DE, 1AC2H
    CALL    FILL_SMARTKEY_REGION
    LD      A, 80H
    LD      B, 1EH
    LD      DE, 1AE2H
    CALL    FILL_SMARTKEY_REGION
    LD      HL, FKEY_TEXT_BLOCKS
    LD      BC, 1EH
    LD      DE, 1AA2H
    CALL    VRAM_WRITE
    LD      HL, SMART_KEY_PATTERNS
    LD      DE, 17D8H
    LD      BC, 28H
    CALL    VRAM_WRITE
    LD      DE, 10F0H
    LD      BC, 10H
    CALL    VRAM_WRITE
    LD      DE, 14F0H
    LD      BC, 10H
    CALL    VRAM_WRITE
    LD      B, 4
    LD      A, 0FFH
    LD      HL, FKEY_FILL_BLOCKS
FILL_SMARTKEY_BLOCKS:
    PUSH    BC
    INC     HL
    LD      E, (HL)
    INC     HL
    LD      D, (HL)
    LD      BC, 8
    CALL    VRAM_FILL
    POP     BC
    DJNZ    FILL_SMARTKEY_BLOCKS
    LD      DE, 34F0H
    CALL    SET_VRAM_WRITE_BIT
    LD      B, 2
SMARTKEY_TIMING_SETUP:
    PUSH    BC
    LD      HL, FKEY_TILE_PATTERN_1
    LD      BC, 8
    CALL    SMARTKEY_TIMING_LOOP
    POP     BC
    DJNZ    SMARTKEY_TIMING_SETUP
    LD      HL, FKEY_TILE_PATTERN_1
    LD      DE, 3600H
    LD      BC, 8
    CALL    VRAM_WRITE
    LD      HL, FKEY_TILE_PATTERN_2
    LD      DE, 3560H
    LD      BC, 8
    CALL    VRAM_WRITE
    LD      HL, FKEY_TILE_PATTERN_3
    LD      DE, 36F8H
    LD      BC, 8
    CALL    VRAM_WRITE
    LD      A, 0AAH
    LD      DE, 3700H
    LD      BC, 8
    CALL    VRAM_FILL
    LD      DE, 30F0H
    LD      B, 2
    LD      HL, FKEY_POINTER_BLOCK_2
    CALL    LOAD_SMARTKEY_POINTERS
    LD      DE, 37D8H
    CALL    SET_VRAM_WRITE_BIT
    LD      B, 5
    LD      HL, FKEY_POINTER_BLOCK_1

LOAD_SMARTKEY_POINTERS:
    CALL    SET_VRAM_WRITE_BIT
LOAD_POINTER_LOOP:
    PUSH    BC
    LD      A, (HL)
    INC     HL
    PUSH    HL
    LD      H, (HL)
    LD      L, A
    LD      BC, 8
    CALL    SMARTKEY_TIMING_LOOP
    POP     HL
    INC     HL
    POP     BC
    DJNZ    LOAD_POINTER_LOOP
RET

SMART_KEY_PATTERNS:
    DB $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
    DB $FF,$C7,$EF,$EF,$EF,$EF,$C7,$FF
    DB $FF,$C1,$EB,$EB,$EB,$EB,$C1,$FF
    DB $FF,$01,$AB,$AB,$AB,$AB,$01,$FF
    DB $FF,$17,$B7,$B7,$BA,$BA,$1D,$FF
    DB $FF,$7F,$7F,$7F,$FF,$FF,$FF,$FF
    DB $FF,$BB,$BB,$BB,$D7,$D7,$EF,$FF
    DB $FF,$FE,$FE,$FE,$FF,$FF,$FF,$FF
    DB $FF,$E8,$ED,$ED,$5D,$5D,$B8,$FF
    DB $5F,$1F,$1F,$1F,$1F,$1F,$1F,$1F
FKEY_TILE_PATTERN_1:
	DB $4F,$1F,$1F,$1F,$1F,$1F,$1F,$1F
FKEY_TILE_PATTERN_2:
	DB $50,$50,$50,$50,$50,$50,$50,$50
FKEY_TILE_PATTERN_3:
	DB $40,$40,$40,$40,$40,$40,$40,$40
FKEY_POINTER_BLOCK_1:
	DB $46,$E0,$46,$E0
FKEY_POINTER_BLOCK_2:
	DB $4E,$E0,$46,$E0,$4E,$E0
FKEY_TEXT_BLOCKS:
	DB $AC,$FB,$FC,$FB,$AC,$DF,$C0,$FD
    DB $C0,$DF,$AC,$FB,$FE,$FB,$AC,$DF
    DB $C0,$FF,$1E,$DF,$AC,$FB,$1F,$FB
    DB $AC,$DF,$9E,$9F,$C0,$DF,$E0,$E0
    DB $E0,$E0
FKEY_FILL_BLOCKS:
	DB $E0,$00,$16,$60,$15,$F8,$16,$00,$17
LOGO_1_PAT: 
	DB $07,$0F,$1F,$1F,$07,$07,$0F,$0F
    DB $F0,$F8,$F8,$FC,$BC,$BE,$1E,$1F
    DB $0F,$1F,$3F,$3F,$0F,$0F,$0F,$0F
    DB $FF,$FF,$FF,$FF,$01,$00,$00,$00
    DB $C0,$E0,$F0,$F0,$F0,$F0,$F0,$F0
    DB $3F,$7F,$FF,$FF,$3D,$3D,$78,$78
    DB $80,$C0,$C1,$E1,$E0,$F0,$F0,$F8
    DB $7F,$FF,$FF,$FF,$7B,$7B,$79,$79
    DB $80,$80,$C1,$C1,$E3,$E3,$F7,$F7
    DB $FF,$FF,$FF,$FF,$EF,$EF,$CF,$CF
    DB $75,$27,$25,$25,$00,$00,$00,$00
    DB $01,$03,$07,$07,$01,$01,$01,$01
    DB $FF,$FF,$FF,$FF,$E0,$E0,$E0,$E0
    DB $F8,$FC,$FE,$FE,$1E,$1E,$00,$00
    DB $3F,$7F,$FF,$FF,$3C,$3C,$3C,$3C
    DB $FF,$FF,$FF,$FF,$07,$03,$03,$03
    DB $00,$80,$C0,$C0,$C0,$C0,$C1,$C1
    DB $3C,$3C,$79,$79,$F0,$F0,$E0,$E0
    DB $3E,$41,$5D,$53,$5D,$55,$3E,$00
LOGO_2_PAT:
	DB $1E,$1F,$3F,$3F,$7F,$7C,$FC,$F8
    DB $0F,$FF,$FF,$FF,$FF,$03,$03,$01
    DB $0F,$8F,$8F,$CF,$CF,$EF,$EF,$EF
    DB $00,$00,$00,$01,$FF,$FF,$FF,$FF
    DB $F0,$F0,$F1,$F1,$F3,$F3,$E7,$C7
    DB $F0,$FF,$FF,$FF,$FF,$E0,$E0,$C0
    DB $78,$FC,$FC,$FE,$FE,$1F,$1F,$0F
    DB $78,$78,$78,$78,$78,$78,$78,$78
    DB $FF,$FF,$7F,$7F,$3E,$3E,$1C,$1C
    DB $8F,$8F,$0F,$0F,$0F,$0F,$0F,$0F
    DB $00,$00,$00,$00,$00,$00,$00,$00
    DB $01,$01,$01,$01,$01,$01,$01,$00
    DB $E0,$E0,$E0,$E0,$FF,$FF,$FF,$FF
    DB $00,$00,$1E,$1E,$FE,$FE,$FC,$F8
    DB $3C,$3F,$3F,$3F,$3F,$3C,$3C,$3C
    DB $07,$FF,$FF,$FF,$FF,$00,$00,$00
    DB $C3,$C3,$C7,$87,$0F,$0F,$1E,$1E
    DB $C0,$C0,$80,$80,$00,$00,$00,$00
KBD_QUEUE_PTR:
	DW $E2D9
KEYBOARD_FILTER_TABLE:
	DB $80,$90,$91,$92,$93,$94,$95,$96,$97,$98,$9A,$9B,$9C,$9D,$9E
    DB $9F,$A0,$A1,$A2,$A3,$A6,$A8,$A9,$AA,$AB,$AC,$AD,$AE,$AF,$B9
    DB $81,$82,$83,$84,$85,$86,$89,$8A,$8B,$8C,$8D,$8E,$A5,$A7,$99
    DB $A4

CONSOLE_INPUT_NULL_HANDLER:
	RR      E
    JR      NC, CONSOLE_INPUT_ERROR_STATUS
    JP      PRINTER_OUTPUT_STATUS

PRINTER_OUTPUT:
    LD      (DCB_SAVE_DSP), SP
    LD      SP, DCB_TEMP_SP
    LD      DE, CONSOLE_STATUS_RETURN
    PUSH    DE
PRINTER_OUTPUT_STATUS:
    LD      DE, 720H
    JR      CONSOLE_INPUT_DISPATCH+1

PUNCH_OUTPUT:
    LD      (DCB_SAVE_DSP), SP
    LD      SP, DCB_TEMP_SP
    LD      DE, CONSOLE_STATUS_RETURN
    PUSH    DE
    LD      DE, 518H
    JR      CONSOLE_INPUT_DISPATCH+1

READER_INPUT:
    LD      (DCB_SAVE_DSP), SP
    LD      SP, DCB_TEMP_SP
    LD      DE, CONSOLE_STATUS_RETURN
    PUSH    DE
CONSOLE_INPUT_ERROR_STATUS:
    LD      DE, 310H
    JR      CONSOLE_INPUT_DISPATCH+1

CONSOLE_OUTPUT:
    LD      (DCB_SAVE_DSP), SP
    LD      SP, DCB_TEMP_SP
    LD      DE, CONSOLE_STATUS_RETURN
    PUSH    DE

DISPLAY_CHARACTER:
    LD      DE, 108H
    JR      CONSOLE_INPUT_DISPATCH+1

CONSOLE_INPUT:
    LD      (DCB_SAVE_DSP), SP
    LD      SP, DCB_TEMP_SP
    LD      DE, CONSOLE_STATUS_RETURN
    PUSH    DE
FLUSH_CONSOLE_INIT:
    LD      DE, 100H
CONSOLE_INPUT_DISPATCH:
    AND     37H
    PUSH    AF
    LD      A, (IOBYTE)
CONSOLE_INPUT_SANITIZE_LOOP:
    CP      0FH
    DEC     D
    JR      NZ, CONSOLE_INPUT_SANITIZE_LOOP+1
CONSOLE_INPUT_INDEX_CALC:
    AND     3
    RLCA
    ADD     A, E
    LD      E, A
CONSOLE_INPUT_LOOKUP:
    LD      HL, CONSOLE_IN_TABLE
    ADD     HL, DE
    LD      A, (HL)
    INC     HL
    LD      H, (HL)
    POP     DE
    LD      L, A
    OR      H
    JR      Z, CONSOLE_INPUT_NULL_HANDLER
    JP      (HL)
CONSOLE_STATUS_FALLBACK:
	RR      E
    JR      C, CONSOLE_STATUS_ERROR
    JP      CONSOLE_STATUS_READY
LIST_STATUS:
    LD      (DCB_SAVE_DSP), SP
    LD      SP, DCB_TEMP_SP
    LD      DE, CONSOLE_STATUS_RETURN
    PUSH    DE
CONSOLE_STATUS_READY:
    LD      BC, 720H        ; LIST_STATUSCODE_READY
    JR      CONSOLE_STATUS_DISPATCH+1
    LD      BC, 518H        ; LIST_STATUSCODE_BUSY
    JR      CONSOLE_STATUS_DISPATCH+1
CONSOLE_STATUS_ERROR:
    LD      BC, 310H        ; LIST_STATUSCODE_ERROR
    JR      CONSOLE_STATUS_DISPATCH+1
    LD      BC, 108H        ; LIST_STATUSCODE_OFFLINE
    JR      CONSOLE_STATUS_DISPATCH+1
CONSOLE_STATUS:
    LD      (DCB_SAVE_DSP), SP
    LD      SP, DCB_TEMP_SP
    LD      DE, CONSOLE_STATUS_RETURN
    PUSH    DE
CONSOLE_STATUS_DEFAULT:
    LD      BC, 100H
CONSOLE_STATUS_DISPATCH:
    AND     37H
    PUSH    AF
    LD      A, (IOBYTE)
CONSOLE_STATUS_IOBYTE_DECODE:
    CP      0FH
    DJNZ    CONSOLE_STATUS_IOBYTE_DECODE+1
    AND     3
    RLCA
    ADD     A, C
    LD      C, A
    LD      HL, CONSOLE_STATUS_TABLE
    ADD     HL, BC
    LD      A, (HL)
    INC     HL
    LD      H, (HL)
    POP     DE
    LD      L, A
    OR      H
    JR      Z, CONSOLE_STATUS_FALLBACK
    JP      (HL)
KEYBOARD_CHECK_READY:
    LD      HL, (KBD_QUEUE_PTR)
    LD      A, (HL)
    OR      A
    JR      NZ, KEYBOARD_RETURN_WITH_CARRY
    SCF
KEYBOARD_PROBE_STATUS_LATCH:
    LD      L, 0AFH
    SBC     A, 0
    LD      C, A
    INC     A
    INC     A
    CALL    DEBOUNCE_TIMING_CHECK
	CCF
    JR      C, KEYBOARD_RETURN_WITH_CARRY
    LD      A, 80H
    XOR     (HL)
    JR      Z, KEYBOARD_RETURN_WITH_CARRY
    JP      M, KEYBOARD_FORCE_NOT_READY
    INC     C
    JR      Z, KEYBOARD_HANDLE_EDGE_CASE
KEYBOARD_FORCE_NOT_READY:
    SCF
KEYBOARD_RETURN_WITH_CARRY:
    LD      A, 0FFH
KEYBOARD_MACRO_RETURN_PT:
    ADC     A, 0
RET

KEYBOARD_HANDLE_EDGE_CASE:
    LD      A, 1
    LD      BC, 1
    LD      HL, KEYBOARD_LATCH_STATUS_BYTE
    CALL    DEVICE_RESET_FLAG
    INC     B
KEYBOARD_WAIT_TIMEOUT_EXIT:
    XOR     A
RET

KEYBOARD_ADVANCE_QUEUE:
    INC     HL
    LD      (KBD_QUEUE_PTR), HL
    LD      HL, KEYBOARD_READY_FLAG
    LD      (HL), 0FFH
RET

KEYBOARD_TOGGLE_READY_FLAG:
    LD      HL, KEYBOARD_INPUT_BYTE ; SYMBOL TABLE (UPPERCASE, UNDERSCORE FORMAT)
    LD      A, (HL)
    XOR     0FFH
    LD      (HL), A
KEYBOARD_WAIT_FOR_INPUT:
    LD      HL, (KBD_QUEUE_PTR)
    LD      A, (HL)
    OR      A
    JR      NZ, KEYBOARD_ADVANCE_QUEUE
    INC     A
    CALL    DEBOUNCE_TIMING_CHECK
    JR      NC, KEYBOARD_WAIT_TIMEOUT_EXIT
KEYBOARD_LATCH_WAIT_LOOP:
    LD      DE, 436H
KEYBOARD_LATCH_SPIN:
    LD      A, 80H
    XOR     (HL)
    JP      M, KEYBOARD_LATCH_SPIN
    JP      NZ, KEYBOARD_LATCH_WAIT_LOOP+1
    LD      A, (KEYBOARD_LATCH_STATUS_BYTE)
    CP      90H
    JP      NZ, WILDCARD_CONTINUE
    XOR     A
    JP      _WILDCARD_CONTINUE
WILDCARD_CONTINUE:
    PUSH    AF
    CALL    KEYBOARD_HANDLE_EDGE_CASE
    POP     AF
    LD      HL, KEYBOARD_FILTER_TABLE
    LD      BC, 2EH 
    CPIR
    EX      DE, HL
    LD      HL, KEYBOARD_READY_FLAG
    LD      B, (HL)
    LD      (HL), 0FFH
    JR      Z, KEYBOARD_SKIP_IF_MATCH
    LD      HL, KEYBOARD_INPUT_BYTE ; SYMBOL TABLE (UPPERCASE, UNDERSCORE FORMAT)
    LD      C, (HL)
    INC     C
    DEC     C
    RET     Z
    CP      61H 
    RET     C
    CP      7BH 
    RET     NC
    AND     0DFH
RET

KEYBOARD_SKIP_IF_MATCH:
    LD      (HL), B
    JP      PO, KEYBOARD_TOGGLE_READY_FLAG
    LD      B, 0
    EX      DE, HL
    LD      A, 3
    CP      C
    JR      NC, KEYBOARD_CHAR_LOOKUP
    LD      A, 0FH
    CP      C
    JR      NC, FKEY_MACRO_RESOLVE
KEYBOARD_MACRO_LOOKUP:
    LD      HL,  KEYBOARD_MACRO_TABLE+1
    ADD     HL, BC
    LD      A, (HL)
    EX      DE, HL
    LD      (HL), 0FFH
RET

KEYBOARD_CHAR_LOOKUP:
    LD      HL, WORD_DC84
    ADD     HL, BC
    LD      C, (HL)
KEYBOARD_DISPLAY_AND_WAI:
    CALL    DISPLAY_CHARACTER
    JP      KEYBOARD_WAIT_FOR_INPUT
FKEY_MACRO_RESOLVE:
    DEC     HL
    LD      A, (BYTE_DC8B)
    OR      A
    JR      Z, KEYBOARD_MACRO_LOOKUP
    LD      A, (HL)
    AND     7
    DEC     A
    LD      C, A
    ADD     A, A
    ADD     A, C
    LD      C, A
    LD      HL, (FKEY_MACRO_PTR)
    ADD     HL, BC
    INC     HL
    LD      E, (HL)
    LD      D, 0
    PUSH    HL
    LD      HL, (FKEY_DESCRIPT)
    EX      DE, HL
    ADD     HL, HL
    ADD     HL, HL
    ADD     HL, HL
    ADD     HL, HL
    ADD     HL, DE
    LD      A, (HL)
    OR      A
    JR      Z, FKEY_MACRO_QUEUE_UPDATE
    INC     HL
FKEY_MACRO_QUEUE_UPDATE:
    LD      (KBD_QUEUE_PTR), HL
    POP     HL
    PUSH    AF
    INC     HL
    LD      L, (HL)
    INC     L
    JR      Z, FKEY_MACRO_EXIT_CHECK
    DEC     L
    LD      H, 0
    ADD     HL, HL
    LD      B, H
    LD      C, L
    ADD     HL, HL
    ADD     HL, HL
    ADD     HL, HL
    ADD     HL, BC
    LD      BC, (FKEY_ADDRESS)
    ADD     HL, BC
    LD      (FKEY_MACRO_PTR), HL
    CALL    FKEY_TOGGLE_HANDLER+1
FKEY_MACRO_EXIT_CHECK:
    POP     AF
    JP      Z, KEYBOARD_WAIT_FOR_INPUT
    CP      7
    RET     NZ
    LD      C, A
    LD      HL,  KEYBOARD_MACRO_RETURN_PT+1
    LD      (KBD_QUEUE_PTR), HL
    JR      KEYBOARD_DISPLAY_AND_WAI

_FLUSH_CONSOLE_INIT:
    CALL    FLUSH_CONSOLE_INIT

FLUSH_CONSOLE_INPUT:
    CALL    CONSOLE_STATUS_DEFAULT
    INC     A
    JR      Z, _FLUSH_CONSOLE_INIT
RET

AUX_WRITE_2BYTE_INIT:
    LD      B, 2
    LD      HL, AUX_DEVICE_BUFFER_1
    JR      AUX_WRITE_STORE_BYT
AUX_WRITE:
    LD      B, 0EH
    LD      HL, AUX_DEVICE_BUFFER_2
AUX_WRITE_STORE_BYT:
    LD      (HL), C
AUX_WRITE_RETRY_LOO:
    PUSH    HL
    PUSH    BC
    LD      A, B
    LD      BC, 1
    CALL    AUX_WRITE_HANDLER
    POP     BC
    POP     HL
    RET     C
    CP      6
    JR      Z, AUX_WRITE_RETRY_LOO
RET

CONSOLE_STATUS_RETURN:
    LD      SP, (DCB_SAVE_DSP)
RET

DEBOUNCE_TIMING_CHECK:
    LD      HL, UNK_FEC3
    LD      B, (HL)
    INC     B
    DEC     B
    JR      Z, DEBOUNCE_FAIL_EXIT
    LD      HL, UNK_FED4
    LD      DE, 15H
    AND     0FH
LOC_E3FC:
    CP      (HL)
    JR      Z, LOC_E402
    ADD     HL, DE
    DJNZ    LOC_E3FC
LOC_E402:
    LD      DE, UNK_FFF0
    ADD     HL, DE
    SCF
    RET     Z
DEBOUNCE_FAIL_EXIT:
    LD      A, 9BH
    OR      A
RET

SET_ACTIVE_DRIVE:
    PUSH    AF
    CALL    DEBOUNCE_TIMING_CHECK
    POP     BC
    LD      A, 44H 
    RET     NC
WAIT_FOR_DRIVE_READY:
    LD      A, (HL)
    RLCA
    JR      NC, WAIT_FOR_DRIVE_READY
    CP      1
    JR      Z, DRIVE_READY_EXIT
    CP      37H
    JR      Z, DRIVE_READY_EXIT
    PUSH    AF
    LD      A, (DRIVE_INIT_FLAG_2)
    INC     A
    JR      NZ, DRIVE_INIT_STATUS_CHECK
    POP     AF
    AND     A
RET
DRIVE_INIT_STATUS_CHECK:
    POP     AF
DRIVE_READY_EXIT:
    SCF
DRIVE_LATCH_SET:
    LD      (HL), 1
DRIVE_LATCH_WAIT_LOOP:
    LD      A, (HL)
    OR      A
    JP      P, DRIVE_LATCH_WAIT_LOOP
    CP      9BH             ; COMPARES LATCH VALUE TO 0X9B
    JR      Z, DRIVE_LATCH_SET
    XOR     80H             ; XORS LATCH VALUE WITH 0X80
    LD      A, 66H
    RET     NZ
    LD      C, 0F0H
    LD      A, B
    AND     C
    LD      A, C
    JR      NZ, DRIVE_BITMASK_VALIDATE
    CPL
DRIVE_BITMASK_VALIDATE:
    LD      BC, 14H
    PUSH    HL
    ADD     HL, BC
    AND     (HL)
    POP     HL
    RET     NZ
DRIVE_FINAL_READY_EXIT:
    SCF
RET

DEVICE_RESET_FLAG:
    PUSH    BC
    PUSH    HL
    CALL    DEBOUNCE_TIMING_CHECK
    JR      NC, DEVICE_RESET_FAIL_EXIT
    LD      A, (HL)
    RLCA
    JR      NC, DEVICE_RESET_FAIL_EXIT
    POP     DE
    POP     BC
    PUSH    HL
    INC     HL
    LD      (HL), E
    INC     HL
    LD      (HL), D
    INC     HL
    LD      (HL), C
    INC     HL
    LD      (HL), B
    POP     HL
DEVICE_STATE_UPDATE:
    POP     DE
    LD      A, (DE)
    INC     DE
    PUSH    DE
    LD      (HL), A
    SCF
RET
DEVICE_RESET_ABORT:
    POP     BC
    POP     BC
    POP     BC
DEVICE_RESET_FAIL_EXIT:
    POP     BC
    POP     BC
    POP     HL
    INC     HL
    JP      (HL)

EXECUTE_MEDIA_SETUP:
    PUSH    AF
    PUSH    BC
    PUSH    DE
    LD      DE, 400H
    PUSH    DE
    PUSH    HL
    CALL    SET_ACTIVE_DRIVE
    JR      NC, DEVICE_RESET_ABORT
    PUSH    HL
    EX      DE, HL
    INC     DE
    LD      HL, 2
    ADD     HL, SP
    LD      BC, 8
    LDIR
    INC     HL
    LD      A, (HL)
    INC     HL
	RRCA
	RRCA
	RRCA
	RRCA
    AND     0FH
    LD      (DE), A
    POP     DE
    LD      SP, HL
    EX      DE, HL
    JR      DEVICE_STATE_UPDATE

AUX_WRITE_ALT_HANDLER:
    LD      E, 4
    JR      AUX_WRITE_INIT

AUX_WRITE_HANDLER:
    LD      E, 3
AUX_WRITE_INIT:
    PUSH    HL
    LD      HL, AUX_WRITE_MODE_BYTE
    LD      (HL), E
    POP     HL
    CALL    DEVICE_RESET_FLAG
AUX_WRITE_MODE_BYTE:
    NOP
    RET     NC
AUX_WRITE_LATCH_WAIT:
    LD      A, (HL)
    XOR     80H
    JP      M, AUX_WRITE_LATCH_WAIT
    RET     NZ
    SCF
RET

DRIVE_INIT_FLAG:
	DB    0
DRIVE_ID_TABLE:
	DB    8
    DB  18H
    DB    4
    DB    5
ACTIVE_DRIVE_BACKUP:
	DB    0
MEDIA_SIGNATURE_SOURCE:
	DB    0
    DB    0
DRIVE_NUM:
	DB    8
LAST_MEDIA_SIGNATURE:
	DB    2
    DB    0
INIT_STATUS_2: 
	DB    0
MEDIA_SIGNATURE_TEMP:
	DB    0
    DB    0
LAST_VALID_DRIVE:
	DB    0
MEDIA_SIGNATURE_BACKUP:
	DB    0
    DB    0
    DB    0
    DB  0DH
    DB    0
    DB    0
    DB  0EH
    DB    0
DRIVE_INIT_FLAG_2:
	DB    0
RETRY_TIMER:
	DB  0AH
ERROR_MESSAGES:
	DB 0
UNKOWNERROR:
	DB 'Unkown Error',0
CRCERROR:
	DB 'CRC Error',0
MISSINGBLOCKAD:
	DB 'Missing Block, Adjust Media',0
MISSINGMEDIA:
	DB 'Missing Media',0
MISSINGDRIVE:
	DB 'Missing Drive',0
WRITEPROTECTED:
	DB 'Write Protected',0
DRIVEERROR:
	DB 'Drive Error',0
IGNORE_ABORT_RETRY_TXT:
	DB $0D,$0A
	DB 'Ignore,Abort,Retry ',0
ABORT_RETRY_TXT:
	DB $0D,$0A
	DB 'Abort,Retry',0
IGNORE_ABORT_TXT:
	DB $0D,$0A
	DB 'Ignore,Abort',0
UKNOWN_DRIVE_TXT:
	DB $0D,$0A
	DB 'Unknown Drive',0
SELECT_DISK:
    LD      (DCB_SAVE_DSP), SP
    LD      SP, DCB_TEMP_SP
    LD      HL, CONSOLE_STATUS_RETURN
    PUSH    HL

INIT_CPM_KERNEL:
    LD      A, 3
    CP      C
    JP      C, HANDLE_RAM_DISK
    LD      HL, 100H
    LD      ($4B), HL
    LD      A, (BOOT_DEVICE_ID)
    XOR     C
    LD      C, A
    LD      B, 0
    LD      HL, STORE_INIT_STATUS
    LD      (HL), B
    LD      HL, DRIVE_ID_TABLE
    ADD     HL, BC
    LD      A, (HL)
    LD      B, A
    PUSH    BC
    LD      B, 0
    LD      H, B
    LD      L, C
    ADD     HL, HL
    ADD     HL, HL
    ADD     HL, HL
    ADD     HL, HL
    LD      BC, DRIVE_DESCRIPTOR_TABLE
    ADD     HL, BC
    CP      8
    PUSH    HL
    JR      NC, DD_PATH_ENTRY
    LD      HL, 0A0H
    LD      ($4B), HL       ; $4B = SYSTEM_BUFFER_PTR
    AND     A
    CALL    DEBOUNCE_TIMING_CHECK
    POP     DE
    JR      NC, DRIVE_STACK_CLEANUP
    LD      HL, DISK_INIT_TABLE
    LD      C, 0
    PUSH    HL
    LD      HL, STORE_INIT_STATUS
    LD      (HL), C
    LD      HL, 0AH         ; STORE_DRIVE_PARAMS
    ADD     HL, DE
    POP     BC
    LD      (HL), C
    INC     HL
    LD      (HL), B
    EX      DE, HL
FINALIZE_DRIVE_ORDER:
    EX      DE, HL
    POP     BC
    LD      HL, DRIVE_ORDER
    LD      A, (BOOT_DEVICE_ID)
    XOR     C
    LD      (HL), A
    INC     HL
    LD      (HL), B
    EX      DE, HL
RET
HANDLE_RAM_DISK:
    LD      A, C
    CP      0CH
    JR      NZ, DRIVE_VALIDATION_FALLBACK
    LD      A, (IS_RAM_DISK_THERE)
    OR      A
    JR      NZ, DRIVE_VALIDATION_FALLBACK
    LD      (CURRENT_DRIVE), A
    LD      A, C
    LD      (DRIVE_ORDER), A
    LD      HL, 38H
    LD      ($4B), HL
    LD      HL, UNK_DE14
RET

DD_PATH_ENTRY:
    PUSH    AF
    CALL    SET_ACTIVE_DRIVE
    POP     BC
    POP     HL
    LD      C, A
    LD      A, 0F0H
    AND     B
    LD      A, C
    JR      Z, DECODE_DRIVE_TYPE
    RLCA
    RLCA
    RLCA
    RLCA
DECODE_DRIVE_TYPE:
    AND     0FH
    CP      4
    JR      NZ, FINALIZE_DRIVE_ORDER
DRIVE_STACK_CLEANUP:
    POP     BC
DRIVE_VALIDATION_FALLBACK:
    LD      HL, UKNOWN_DRIVE_TXT ; "\R\NUNKNOWN DRIVE"
    CALL    DISPLAY_SCREEN
    CALL    FLUSH_CONSOLE_INPUT
PROMPT_IGNORE_ABORT:
    LD      HL, IGNORE_ABORT_TXT ; "\R\NIGNORE,ABORT"
    CALL    DISPLAY_SCREEN
    CALL    FLUSH_CONSOLE_INIT
    LD      HL, 0
    AND     5FH 
    CP      49H 
    RET     Z
    CP      41H 
    JR      NZ, PROMPT_IGNORE_ABORT
    LD      A, (TDRIVE)
    AND     0F0H
    LD      (TDRIVE), A
    JP      JP_WARM_BOOT

HOME_DISK:
    LD      H, B
    LD      L, C
RET

SELECT_TRACK:
    LD      (CUR_MEDIA_SIGNNATURE), BC
RET

SELECT_SECTOR:
    LD      (MEDIA_SIGNATURE_WORD), BC
RET

SELECT_DMA:
    LD      (MEDIA_LOOP_EXIT), BC
RET

DEFAULT_DRIVE_HANDLER:
    LD      A, (DRIVE_NUM)
    OR      A
    JR      NZ, MEDIA_CHANGED_REINIT
    LD      HL, (LAST_MEDIA_SIGNATURE)
    LD      DE, (CUR_MEDIA_SIGNNATURE)
    SBC     HL, DE
    JR      Z, NO_CHANGE_FASTPATH
MEDIA_CHANGED_REINIT:
    LD      (LAST_MEDIA_SIGNATURE), DE
    XOR     A
    LD      (DRIVE_NUM), A
    LD      (DRIVE_INIT_FLAG), A
    CALL    DRIVE_HW_SELECT_INIT
    LD      BC, DRIVE_REINIT_CONT
    LD      A, 2
	OUT     (MEM_PORT), A
    JP      TBASE
DRIVE_REINIT_CONT:
    LD      HL, 400H
    LD      DE, MEDIA_SETUP_ROUTINE
    LD      B, H
    LD      C, L
    LDIR
    LD      A, 1
	OUT     (MEM_PORT), A
NO_CHANGE_FASTPATH:
    LD      BC, 80H
    LD      L, 0
    LD      A, (MEDIA_SIGNATURE_WORD)
	RRA
    LD      H, A
	RR      L
    LD      DE, MEDIA_SETUP_ROUTINE
    ADD     HL, DE
    LD      DE, (MEDIA_LOOP_EXIT)
    POP     AF
    JR      NC, COPY_MEDIA_BLOCK
    EX      DE, HL
COPY_MEDIA_BLOCK:
    LDIR
    JP      NC, MEDIA_TRANSFER_COMPLETE
MEDIA_RELOAD_PHASE2_:
    LD      HL, MEDIA_SETUP_ROUTINE
    LD      DE, 400H
    LD      B, D
    LD      C, E
    LD      A, 2
	OUT     (MEM_PORT), A
    LDIR
    CALL    DRIVE_HW_SELECT_INIT
    EX      DE, HL
    LD      BC, MEDIA_FINALIZE_HANDLER
    JP      TBASE
MEDIA_FINALIZE_HANDLER:
    LD      A, 1
	OUT     (MEM_PORT), A
    JP      MEDIA_TRANSFER_COMPLETE
READ:
    LD      (DCB_SAVE_DSP), SP
    LD      SP, DCB_TEMP_SP
    LD      HL, CONSOLE_STATUS_RETURN
    PUSH    HL
    JR      HANDLE_CONSOLE_IO
WRITE:
    LD      (DCB_SAVE_DSP), SP
    LD      SP, DCB_TEMP_SP
    LD      HL, CONSOLE_STATUS_RETURN
    PUSH    HL
    JR      HANDLE_CONSOLE_IO+1
HANDLE_CONSOLE_IO:
    OR      37H
    LD      A, C
    PUSH    AF
    LD      A, (CURRENT_DRIVE)
    OR      A
    JP      Z, DEFAULT_DRIVE_HANDLER
    LD      HL, DRIVE_NUM
    CALL    VALIDATE_DRIVE
    JP      Z, INVALID_DRIVE_HANDLER
    CALL    INIT_DRIVE_IF_NEEDED
    JP      NC, DRIVE_ERROR_PROMPT
    XOR     A
    LD      (DRIVE_INIT_FLAG), A
    LD      A, (DRIVE_NUM)
    CALL    SET_ACTIVE_DRIVE
    JP      FINALIZE_CONSOLE_IO
FINALIZE_CONSOLE_IO:
    LD      HL, CURRENT_DRIVE
    CALL    UPDATE_DRIVE_CONTEXT
    POP     AF
    PUSH    AF
    JR      NC, DRIVE_RETRY_SEQUENCE
    CP      2
    JR      NZ, CHECK_INIT_STATUS
    LD      A, (CURRENT_DRIVE)
    LD      (LAST_VALID_DRIVE), A
    LD      HL, (CUR_MEDIA_SIGNNATURE)
    INC     HL
    LD      (MEDIA_SIGNATURE_BACKUP), HL
    JR      INVALID_DRIVE_HANDLER
CHECK_INIT_STATUS:
    LD      A, (STORE_INIT_STATUS)
    OR      A
    JR      Z, DRIVE_RETRY_SEQUENCE
    LD      HL, LAST_VALID_DRIVE
    CALL    VALIDATE_DRIVE
    LD      (HL), 0
    JR      Z, INVALID_DRIVE_HANDLER
DRIVE_RETRY_SEQUENCE:
    CALL    RESET_DRIVE_STATE
    JR      NC, DRIVE_ERROR_PROMPT
    CALL    SET_ACTIVE_DRIVE
    JR      NC, DRIVE_ERROR_PROMPT
    CALL    RESET_DRIVE_STATE
    JR      NC, DRIVE_ERROR_PROMPT
    CALL    SET_ACTIVE_DRIVE
    JR      NC, DRIVE_ERROR_PROMPT
    POP     AF
    PUSH    AF
    CALL    NC, DRIVE_POST_RETRY_HANDLER
INVALID_DRIVE_HANDLER:
    LD      A, (MEDIA_SIGNATURE_WORD)
    LD      H, A
    LD      L, 0
    SRL     H
	RR      L
    LD      BC, MEDIA_SETUP_ROUTINE
    ADD     HL, BC
    LD      DE, (MEDIA_LOOP_EXIT)
    LD      BC, 80H
    POP     AF
    PUSH    AF
    JR      NC, MEDIA_COPY_BLOCK
    EX      DE, HL
    DEC     A
    LD      A, 0FFH
    LD      (DRIVE_INIT_FLAG), A
MEDIA_COPY_BLOCK:
    LDIR
    JR      NZ, DRIVE_READY_RETRY_EXIT
    CALL    INIT_DRIVE_IF_NEEDED
    JR      NC, DRIVE_ERROR_PROMPT
DRIVE_READY_RETRY_EXIT:
    POP     AF
MEDIA_TRANSFER_COMPLETE:
    XOR     A
RET

DRIVE_ERROR_PROMPT:
    PUSH    AF
    CALL    SIGNON
    POP     BC
    LD      A, 0FH
    AND     B
    JR      NZ, SET_ERROR_INDEX
    LD      A, B
	RRCA
	RRCA
	RRCA
	RRCA
    AND     0FH
SET_ERROR_INDEX:
    LD      D, A
    INC     D
DISPLAY_ERROR_MESSAGE:
    PUSH    DE
    XOR     A
    LD      HL, ERROR_MESSAGES
SEARCH_ERROR_LOOP:
    LD      B, 0FFH
    CPIR
    DEC     D
    JR      NZ, SEARCH_ERROR_LOOP
    CALL    DISPLAY_SCREEN
    CALL    FLUSH_CONSOLE_INPUT
    POP     DE
    LD      HL, ABORT_RETRY_TXT
    LD      A, D
    CP      2
    JR      NZ, DISPLAY_PROMPT
    LD      HL, IGNORE_ABORT_RETRY_TXT
DISPLAY_PROMPT:
    PUSH    DE
    CALL    DISPLAY_SCREEN
    CALL    FLUSH_CONSOLE_INIT
    AND     5FH 
    LD      C, 0
    POP     DE
    CP      52H 
    JP      Z, FINALIZE_CONSOLE_IO
    POP     BC
    CP      41H 
    JR      NZ, HANDLE_IGNORE_OPTION
HANDLE_ABORT:
    LD      A, (TDRIVE)
    AND     0F0H
    LD      (TDRIVE), A
    JP      JP_WARM_BOOT
HANDLE_IGNORE_OPTION:
    SUB     49H 
    JR      NZ, REDISPLAY_ERROR_MESSAGE
    LD      A, D
    CP      2
    RET     Z
REDISPLAY_ERROR_MESSAGE:
    PUSH    BC
    PUSH    DE
    CALL    SIGNON
    POP     DE
    JR      DISPLAY_ERROR_MESSAGE

UPDATE_DRIVE_CONTEXT:
    LD      DE, DRIVE_NUM
    LD      BC, 3
    LDIR
RET

VALIDATE_DRIVE:
    PUSH    HL
    LD      DE, (CUR_MEDIA_SIGNNATURE)
    LD      BC, (CURRENT_DRIVE)
COMPARE_SIGNATURE:
    LD      B, 0E5H
    LD      A, (HL)
    CP      C
    JR      NZ, VALIDATE_DRIVE_EXIT
    INC     HL
    LD      A, (HL)
    CP      E
    JR      NZ, VALIDATE_DRIVE_EXIT
    INC     HL
    LD      A, (HL)
    CP      D
VALIDATE_DRIVE_EXIT:
    POP     HL
RET

READ1BLOCK:
    PUSH    DE
    PUSH    BC
    PUSH    AF
    CALL    INIT_DRIVE_IF_NEEDED
    JP      NC, READ_BLOCK_FASTPATH
    POP     BC
    POP     DE
    LD      A, (DRIVE_NUM)
    LD      (ACTIVE_DRIVE_BACKUP), A
    CP      B
    JR      NZ, DRIVE_CONTEXT_UPDATE_REQUIRED
    LD      HL, (LAST_MEDIA_SIGNATURE)
    OR      A
    SBC     HL, DE
    JR      NZ, DRIVE_CONTEXT_UPDATE_REQUIRED
    LD      A, (INIT_STATUS_2)
    OR      A
    JR      Z, READ1BLOCK_FINAL_COPY
DRIVE_CONTEXT_UPDATE_REQUIRED:
    LD      C, B
    LD      A, B
    LD      (DRIVE_NUM), A
    LD      HL, (MEDIA_SIGNATURE_SOURCE)
    LD      (LAST_MEDIA_SIGNATURE), DE
    LD      HL, INIT_STATUS_2
    CALL    COMPARE_SIGNATURE+1
    LD      B, 2
    PUSH    BC
    JR      Z, DRIVE_ACTIVATION_SEQUENCE
    POP     BC
READ1BLOCK_RETRY_LOOP:
    PUSH    BC
    CALL    RESET_DRIVE_STATE
    JR      NC, MEDIA_BLOCK_TRANSFER
DRIVE_ACTIVATION_SEQUENCE:
    LD      A, (DRIVE_NUM)
    CALL    SET_ACTIVE_DRIVE
    JR      NC, MEDIA_BLOCK_TRANSFER
    POP     BC
    DJNZ    READ1BLOCK_RETRY_LOOP
READ1BLOCK_FINAL_COPY:
    POP     DE
    LD      HL, MEDIA_SETUP_ROUTINE
    LD      BC, 400H
    LDIR
DRIVE_POST_RETRY_HANDLER:
    LD      HL, (LAST_MEDIA_SIGNATURE)
    INC     HL
    LD      (MEDIA_SIGNATURE_TEMP), HL
    LD      A, (DRIVE_NUM)
    LD      (INIT_STATUS_2), A
    CALL    DEBOUNCE_TIMING_CHECK
    JR      NC, POST_RETRY_EXIT
    LD      A, (HL)
    OR      A
    JP      P, POST_RETRY_EXIT
    LD      (HL), 1
TIMING_SPIN_LOOP:
    LD      A, (HL)
	RLA
    JR      NC, TIMING_SPIN_LOOP
    OR      A
    JR      Z, POST_RETRY_FALLBACK
    LD      (HL), 1
POST_RETRY_EXIT:
    XOR     A
    LD      (INIT_STATUS_2), A
    SCF
RET

POST_RETRY_FALLBACK:
    LD      HL, (MEDIA_SIGNATURE_TEMP)
    LD      DE, ($4B)
    SBC     HL, DE
    JR      NC, POST_RETRY_EXIT
    LD      HL, INIT_STATUS_2
    JP      LOC_E8ED
READ_BLOCK_FASTPATH:
    POP     BC
    POP     BC
    POP     BC
RET

MEDIA_BLOCK_TRANSFER:
    POP     BC
    LD      A, (ACTIVE_DRIVE_BACKUP)
    LD      (DRIVE_NUM), A
    LD      BC, (MEDIA_SIGNATURE_SOURCE)
    LD      (LAST_MEDIA_SIGNATURE), BC
    POP     BC
RET

WRITE1BLOCK:
    PUSH    AF
    PUSH    BC
    PUSH    DE
    CALL    INIT_DRIVE_IF_NEEDED
    JR      NC, READ_BLOCK_FASTPATH
    POP     HL
    LD      DE, MEDIA_SETUP_ROUTINE
    LD      BC, 400H
    LDIR
    LD      A, 0FFH
    LD      (DRIVE_INIT_FLAG), A
    POP     HL
    LD      (LAST_MEDIA_SIGNATURE), HL
    POP     AF
    LD      (DRIVE_NUM), A
INIT_DRIVE_IF_NEEDED:
    LD      HL, (LAST_MEDIA_SIGNATURE)
    INC     H
    DEC     H
    JR      NZ, SKIP_MEDIA_SETUP
    LD      A, L
    LD      HL, MEDIA_SETUP_ROUTINE
    LD      BC, 400H
SKIP_MEDIA_SETUP:
    LD      A, (DRIVE_INIT_FLAG)
    OR      A
    SCF
    RET     Z
    LD      A, 0AH
    LD      (RETRY_TIMER), A
CLEAR_INIT_FLAGS:
    XOR     A
    LD      (DRIVE_INIT_FLAG_2), A
    LD      (INIT_STATUS_2), A
    LD      HL, DRIVE_NUM
    LD      A, 3
    JR      SETUP_MEDIA_PARAMS

RESET_DRIVE_STATE:
    LD      HL, DRIVE_NUM
    XOR     A
    LD      (INIT_STATUS_2), A

LOC_E8ED:
    LD      A, 4
SETUP_MEDIA_PARAMS:
    LD      (MEDIA_PARAM_MODE), A
	RRA
    LD      A, (HL)
    INC     HL
    LD      E, (HL)
    INC     HL
    LD      D, (HL)
    LD      HL, MEDIA_SETUP_ROUTINE
    LD      BC, 0
    PUSH    AF
    PUSH    DE
    PUSH    HL
    CALL    EXECUTE_MEDIA_SETUP

MEDIA_PARAM_MODE:
    INC     BC
    POP     HL
    POP     DE
    POP     BC
    JR      NC, MEDIA_SETUP_SUCCESS
    LD      A, B
    BIT     0, C
    RET     Z
    XOR     A
    LD      (DRIVE_INIT_FLAG), A
    DEC     A
    LD      (DRIVE_INIT_FLAG_2), A
    LD      A, B
    CALL    SET_ACTIVE_DRIVE
    JR      C, MEDIA_SETUP_FAILURE
    LD      A, (RETRY_TIMER)
    DEC     A
    LD      (RETRY_TIMER), A
    JR      NZ, CLEAR_INIT_FLAGS
MEDIA_SETUP_FAILURE:
    PUSH    AF
    XOR     A
    LD      (DRIVE_INIT_FLAG_2), A
    POP     AF
RET
MEDIA_SETUP_SUCCESS:
    PUSH    AF
    XOR     A
    LD      (DRIVE_INIT_FLAG), A
    POP     AF
RET

DRIVE_HW_SELECT_INIT:
    LD      A, (CUR_MEDIA_SIGNNATURE)
    INC     A
    INC     A
	RLA
	RLA
    AND     0FCH
    LD      H, A
    LD      L, 0
    LD      DE, 400H
RET

CURSOR_X_POS_COUNT:
	DW 0
FKEY_STATUS:
	DW 0
FKEY_TEMP_STORAGE:
	DW 0
FKEY_TEMP_OFFSET:
	DW 0
CURSOR_SPRITE_MODE:
	DB 0
ACTIVE_DEVICE:
	DB 0
FKEY_CURRENT_INDEX:
	DB 0
FKEY_DEFAULT_RAM:
	DB 14H
FKEY_CURRENT_HANDLER:
	DW FKEY_HANDLER_DEFAULT
FKEY_NEXT_HANDLER:
	DW SOME_TABLE_00
FKEY_LOOKUP:
	DB    0
    DW FKEY_HANDLER_ENTRY_00
    DB    1
    DW SET_COLOR_TABLE_2
    DB    1
    DW FKEY_RENDER_INIT
    DB    0
    DW SCROLL_DOWN
    DB    0
    DW CURSOR_CONTROL_HANDLER
    DB    0
    DW MOVE_CURSOR_LEFT
    DB    0
    DW MOVE_CURSOR_RIGHT
    DB    0
    DW SCROLL_UP
    DB    0
    DW MOVE_CURSOR_UP
    DB    0
    DW FKEY_HANDLER_26+1
    DB    0
    DW FKEY_HANDLER_25
    DB    0
    DW HANDLE_ROW_SCROLLING
    DB    0
    DW FKEY_HANDLER_CHAR_MODE_SET
    DB    0
    DW FKEY_HANDLER_CHAR_MODE_SET+1
    DB    0
    DW GET_FKEY_STATUS
    DB    0
    DW SET_FKEY_STATUS
    DB    1
    DW VDP_REGISTER_WRITE_SETUP
    DB    1
    DW SET_COLOR_TABLE_1
    DB    0
    DW DEALS_WITH_ROW_HELPER+1
    DB    0
    DW RESTORE_DEVICE_HANDLER
    DB    0
    DW CURSOR_CONTROL_HANDLER+1
    DB    2
    DW FKEY_HANDLER_POSITION_DECODE
SCREEN_ROWS:
	DW ROW_00
    DW ROW_01
    DW ROW_02
    DW ROW_03
    DW ROW_04
    DW ROW_05
    DW ROW_06
    DW ROW_07
    DW ROW_08
    DW ROW_09
    DW ROW_10
    DW ROW_11
    DW ROW_12
    DW ROW_13
    DW ROW_14
    DW ROW_15
    DW ROW_16
    DW ROW_17
    DW ROW_18
    DW ROW_19
    DW ROW_20
    DW ROW_21
    DW ROW_22
    DW ROW_23

PUT_CHAR_AT_CURSOR:
    LD      L, C
    LD      A, 0D0H
    LD      BC, 1
    LD      DE, 3880H
    CALL    VRAM_FILL
    LD      C, L
    LD      HL, 0
    LD      (CURSOR_SPRITE_MODE), HL
    LD      HL, (CURSOR_X_POS_COUNT)
    CALL    HANDLE_SPECIAL_CHARACTER_MAIN
    LD      (CURSOR_X_POS_COUNT), HL
    CALL    SHOW_CURSOR_OR_SPRITE
    XOR     A
    LD      (KEYBOARD_READY_FLAG), A
    LD      A, (CHAR_INPUT_MODE_FLAG)
    OR      A
    RET     NZ
    LD      A, (CURSOR_X_POS_COUNT)
    LD      HL, (CURSOR_LEFT_BOUNDARY)
    SUB     L
    RET     C
    CP      1DH
    RET     NC
    ADD     A, 2
    ADD     A, A
    ADD     A, A
    ADD     A, A
    LD      BC, 1
    LD      DE, 3881H
    CALL    VRAM_FILL
    LD      A, (CURSOR_X_POS_COUNT+1)
    ADD     A, A
    ADD     A, A
    ADD     A, A
    DEC     A
    LD      BC, 1
    LD      DE, 3880H
    JP      VRAM_FILL

DISPATCH_SPECIAL_CHAR:
    ADD     A, A
    EX      DE, HL
    LD      HL, DISPATCH_TABLE
    ADD     A, L
    LD      L, A
    JR      NC, LOC_EA20
    INC     H
LOC_EA20:
    LD      A, (HL)
    INC     HL
    LD      H, (HL)
    LD      L, A
    PUSH    HL
    EX      DE, HL
RET

FKEY_HANDLER_DISPATCH:
    LD      (FKEY_CURRENT_INDEX), A
    EX      DE, HL
    LD      HL, (FKEY_CURRENT_HANDLER)
    LD      (HL), C
    INC     HL
    LD      (FKEY_CURRENT_HANDLER), HL
    LD      HL, (FKEY_NEXT_HANDLER)
    EX      DE, HL
    RET     NZ
    PUSH    DE
FKEY_HANDLER_CHAIN_CONTINUE:
    LD      DE, FKEY_HANDLER_DEFAULT
    LD      (FKEY_CURRENT_HANDLER), DE
RET

FKEY_INPUT_DISPATCH:
    LD      A, C
    EX      DE, HL
    LD      HL, KEYBOARD_SCAN_MAP ; POSSIBLE COMMAND CODES FOR ESC-???
    LD      BC, 16H
    CPIR
    EX      DE, HL
    RET     NZ
FKEY_MATCH_FOUND:
    EX      DE, HL
    LD      HL, FKEY_LOOKUP
    ADD     HL, BC
    ADD     HL, BC
    ADD     HL, BC
    LD      A, (HL)
    LD      (FKEY_CURRENT_INDEX), A
    INC     HL
    LD      C, (HL)
    INC     HL
    LD      B, (HL)
    LD      (FKEY_NEXT_HANDLER), BC
    EX      DE, HL
    OR      A
    RET     NZ
FKEY_CHAIN_EXECUTION:
    PUSH    BC
    JR      FKEY_HANDLER_CHAIN_CONTINUE

MOVE_CURSOR_RIGHT:
    INC     L
    LD      A, 50H 
    SUB     L
    RET     NZ
    LD      L, A
RET

MOVE_CURSOR_LEFT:
    DEC     L
    LD      A, L
    INC     A
    RET     NZ
    LD      L, 4FH
RET

MOVE_CURSOR_UP:
    DEC     H
    LD      A, H
    INC     A
    RET     NZ
    LD      H, A
RET

SCROLL_UP:
    INC     H
    LD      A, (FKEY_DEFAULT_RAM)
    INC     A
    SUB     H
    RET     NZ
    DEC     H
    XOR     A
RET

SCROLL_DOWN:
    CALL    MOVE_CURSOR_UP
    RET     NZ
    PUSH    HL
    LD      BC, 730H
    LD      HL, LAST_ROW_START
    LD      DE, LAST_ROW_END
    LDDR
    LD      DE, ROW_00
    JR      SET_CURSOR_AFTER_SCROLL

HANDLE_SPECIAL_CHARACTER_MAIN:
    LD      A, (FKEY_CURRENT_INDEX)
    DEC     A
    JP      P, FKEY_HANDLER_DISPATCH
    LD      A, C
    CP      20H
    JP      C, DISPATCH_SPECIAL_CHAR
    LD      A, (BYTE_DC8D)
    XOR     C
    LD      C, A
    CALL    PROCESS_KEY_ACTION
    CALL    MOVE_CURSOR_RIGHT
    RET     NZ
FKEY_HANDLER_07:
    CALL    SCROLL_UP
    RET     NZ
    LD      A, (FKEY_DEFAULT_RAM)
    LD      H, A
    PUSH    HL
    LD      DE, ROW_00
    LD      HL, ROW_01
    LD      BC, 730H
    LD      A, (FKEY_DEFAULT_RAM)
	RRCA
    JR      C, COPY_ROW_TO_TOP
    LD      BC, 640H
COPY_ROW_TO_TOP:
    LDIR
SET_CURSOR_AFTER_SCROLL:
    LD      BC, 4FH
    JR      ROW_SCROLL_EXECUTE
MOVE_CURSOR_DOWN_HELPER:
    LD      A, L
    AND     0F8H
    JR      Z, LOC_EADE
    CP      L
    JR      NZ, LOC_EADE
    SUB     8
LOC_EADE:
    LD      L, A
RET

MOVE_CURSOR_LEFT_BOUNDARY_HELPER:
    LD      A, L
    AND     0F8H
    ADD     A, 8
    CP      4FH
    JR      C, LOC_EAEB
    LD      A, 4EH
LOC_EAEB:
    LD      L, A
RET

HANDLE_ROW_SCROLLING:
    LD      E, 0
    LD      D, H
    PUSH    HL
    EX      DE, HL
    JR      DEALS_WITH_ROW
MOVE_TO_BEGINNING_OF_LINE:
    LD      L, 0
    JR      DEALS_WITH_ROW_HELPER+1
CURSOR_CONTROL_HANDLER:
    AND     37H
    LD      A, 0FFH
    LD      (ACTIVE_DEVICE), A
    LD      HL, 0
    RET     C
RESTORE_DEVICE_HANDLER:
    LD      A, (FKEY_DEFAULT_RAM)
    LD      D, A
DEALS_WITH_ROW_HELPER:
    CP      54H
    LD      E, 4FH
    PUSH    HL
DEALS_WITH_ROW:
    PUSH    DE
    CALL    GET_ROW_ADDRESS
    EX      (SP), HL
    CALL    GET_ROW_ADDRESS
    POP     DE
    LD      A, L
    SUB     E
    LD      C, A
    LD      A, H
    SBC     A, D
    LD      B, A
ROW_SCROLL_EXECUTE:
    LD      H, D
    LD      L, E
    INC     DE
    LD      (HL), 20H
    LD      A, B
    OR      C
    JR      Z, FINALIZE_CURSOR_STATE
    LDIR
FINALIZE_CURSOR_STATE:
    LD      HL, CURSOR_SPRITE_MODE
    SET     7, (HL)
    POP     HL
RET

FKEY_HANDLER_ENTRY_09:
    LD      A, (FKEY_DEFAULT_RAM)
    CP      14H
    JR      Z, FKEY_HANDLER_ENTRY_04
FKEY_HANDLER_ENTRY_08:
    CALL    FKEY_HANDLER_CONTROL_01
FKEY_HANDLER_05:
    LD      A, 0AFH
    LD      (BYTE_DC8B), A
RET

FKEY_HANDLER_ENTRY_00:
    PUSH    HL
    CALL    SETUP_FKEY_VARS
    POP     HL

FKEY_HANDLER_CONTROL_01:
    LD      A, 14H
    LD      (FKEY_DEFAULT_RAM), A
    CP      H
    JR      NC, FKEY_HANDLER_INIT_UI
    LD      H, A
FKEY_HANDLER_INIT_UI:
    PUSH    HL
    CALL    INIT_SMARTKEY_UI
FKEY_STUFF_03:
    CALL    FKEY_TOGGLE_HANDLER+1
    POP     HL
RET

FKEY_HANDLER_ENTRY_04:
    CALL    FKEY_HANDLER_05+1
FKEY_HANDLER_ROW_21:
    LD      A, 17H
    LD      (FKEY_DEFAULT_RAM), A
    PUSH    HL
    LD      DE, ROW_21
    LD      BC, 0F0H
    JR      ROW_SCROLL_EXECUTE
FUNC_KEY_HANDLER:
    PUSH    HL
    LD      A, C
    AND     1
	RRCA
    LD      D, A
    LD      A, (CONSOLE_BUFFER_END)
    LD      C, A
    LD      B, 0
    LD      H, B
    LD      L, C
    ADD     HL, HL
    PUSH    HL
    ADD     HL, BC
    EX      DE, HL
    LD      HL, DEVICE_ID_TABLE
    ADD     HL, DE
    LD      A, (HL)
    AND     7FH
    OR      D
    LD      (HL), A
    EX      DE, HL
    ADD     HL, HL
    EX      (SP), HL
    LD      B, H
    LD      C, L
    ADD     HL, HL
    ADD     HL, HL
    ADD     HL, BC
    EX      DE, HL
    LD      HL, FUNCTION_KEY_TEXT_A
    ADD     HL, DE
    PUSH    DE
    EX      DE, HL
    LD      HL, FKEY_TEXT_BUFFER_1
    LD      BC, 0AH
    LDIR
    POP     DE
    POP     HL
    ADD     HL, DE
    LD      DE, FUNCTION_KEY_TEXT_B
    ADD     HL, DE
    EX      DE, HL
    LD      HL, FKEY_TEXT_BUFFER_2
    LD      BC, 0FH
    LDIR
    POP     HL
    LD      A, (FKEY_DEFAULT_RAM)
	RRA
    RET     C
    PUSH    HL
    JR      FKEY_STUFF_03
FKEY_RENDER_INIT:
    LD      A, C
    SUB     3BH
    CP      6
    RET     NC
    LD      (CONSOLE_BUFFER_END), A
    EX      DE, HL
    LD      A, 10H
    LD      (FKEY_RENDER_COUNTER), A
    LD      HL, FKEY_TEXT_BUFFER_1
    LD      (FKEY_RENDER_PTR), HL
FKEY_HANDLER_CHAIN_START:
    LD      HL, FKEY_RENDER_LOOP_1
    LD      (FKEY_NEXT_HANDLER), HL
    LD      A, 1
    LD      (FKEY_CURRENT_INDEX), A
    EX      DE, HL
RET

FKEY_RENDER_LOOP_1:
    EX      DE, HL
    LD      HL, (FKEY_RENDER_PTR)
    LD      (HL), C
    INC     C
    DEC     C
    JR      Z, FKEY_BUFFER_SWAP
    LD      A, (FKEY_RENDER_COUNTER)
    DEC     A
    JR      Z, FKEY_HANDLER_CHAIN_START
    LD      (FKEY_RENDER_COUNTER), A
    INC     HL
    LD      (FKEY_RENDER_PTR), HL
    JR      FKEY_HANDLER_CHAIN_START
FKEY_BUFFER_SWAP:
    PUSH    DE
    LD      DE, FKEY_TEXT_BUFFER_2
    LD      HL, FKEY_TEXT_BUFFER_1
    LD      (FKEY_RENDER_PTR), HL
    LD      BC, 0FH
    LDIR
    POP     DE
    LD      A, 0BH
    LD      (FKEY_RENDER_COUNTER), A
FKEY_HANDLER_CHAIN_NEXT:
    LD      A, 1
    LD      (FKEY_CURRENT_INDEX), A
    LD      HL, FKEY_RENDER_LOOP_2
    LD      (FKEY_NEXT_HANDLER), HL
    EX      DE, HL
RET

FKEY_RENDER_LOOP_2:
    EX      DE, HL
    INC     C
    DEC     C
    LD      A, (FKEY_RENDER_COUNTER)
    JR      Z, FKEY_RENDER_FINALIZE
    DEC     A
    JR      Z, FKEY_HANDLER_CHAIN_NEXT
    LD      (FKEY_RENDER_COUNTER), A
    LD      HL, (FKEY_RENDER_PTR)
    LD      (HL), C
    INC     HL
    LD      (FKEY_RENDER_PTR), HL
    JR      FKEY_HANDLER_CHAIN_NEXT
FKEY_RENDER_FINALIZE:
    PUSH    DE
    DEC     A
    JR      Z, FKEY_HANDLER_CHAIN_EXIT
    LD      HL, FKEY_TEXT_PAD_START
    LD      DE, FKEY_TEXT_PAD_END
    LD      B, C
    LD      C, A
    LD      (HL), 20H
    LDDR
FKEY_HANDLER_CHAIN_EXIT:
    LD      A, 1
    LD      (FKEY_CURRENT_INDEX), A
    LD      HL, FUNC_KEY_HANDLER
    LD      (FKEY_NEXT_HANDLER), HL
    POP     HL
RET

FKEY_HANDLER_CHAIN_ENTRY_24:
    LD      A, 1
    LD      (FKEY_CURRENT_INDEX), A
    LD      DE, FKEY_INPUT_DISPATCH
    LD      (FKEY_NEXT_HANDLER), DE
RET

FKEY_HANDLER_POSITION_DECODE:
    LD      HL, (FKEY_CURRENT_HANDLER)
    LD      A, (HL)
    INC     HL
    SUB     20H
    LD      D, A
    LD      A, (HL)
    SUB     20H
    LD      E, A
    EX      DE, HL
RET

DEVICE_RESET_HANDLER:
    LD      A, 0FFH
    LD      (ACTIVE_DEVICE), A
    LD      L, 0
RET

CURSOR_LEFT_WRAP_HANDLER:
    CALL    MOVE_CURSOR_LEFT
    CALL    Z, MOVE_CURSOR_UP
    LD      C, 20H

PROCESS_KEY_ACTION:
    PUSH    HL
    CALL    GET_ROW_ADDRESS
    LD      (HL), C
    LD      (FKEY_TEMP_STORAGE), HL
    LD      HL, CURSOR_SPRITE_MODE
    SET     0, (HL)
    POP     HL
    LD      (FKEY_TEMP_OFFSET), HL
SOME_TABLE_00:
RET

FKEY_HANDLER_25:
    LD      A, 80H
FKEY_HANDLER_26:
    CP      0AFH
    LD      (BYTE_DC8D), A
RET

FKEY_HANDLER_15:
    LD      A, 0AFH
    LD      (KEYBOARD_READY_FLAG), A
RET

FKEY_HANDLER_CHAR_MODE_SET:
    LD      A, 0AFH
    LD      (CHAR_INPUT_MODE_FLAG), A
RET

VDP_REGISTER_WRITE_SETUP:
    LD      B, 7
    JP      WRITE_VDP_REG
SET_COLOR_TABLE_1:
    LD      DE, VDP_COLOR_TABLE_1
    JR      WRITE_COLOR_TABLE_ENTRY
SET_COLOR_TABLE_2:
    LD      DE, VDP_COLOR_TABLE_2
WRITE_COLOR_TABLE_ENTRY:
    PUSH    HL
    EX      DE, HL
    LD      (HL), C
    CALL    FILL_VDP_COLOR_TABLES
    POP     HL
RET

CURSOR_LEFT_BOUNDARY_DEC:
    LD      A, (CURSOR_LEFT_BOUNDARY)
    OR      A
    RET     Z
    DEC     A
    LD      (CURSOR_LEFT_BOUNDARY), A
    LD      A, 80H
    LD      (CURSOR_SPRITE_MODE), A
RET

CURSOR_LEFT_BOUNDARY_INC:
    LD      A, (CURSOR_LEFT_BOUNDARY)
    INC     A
    CP      33H
    RET     NC
    LD      (CURSOR_LEFT_BOUNDARY), A
    LD      A, 80H
    LD      (CURSOR_SPRITE_MODE), A
RET

GET_ROW_ADDRESS:
    LD      A, H
    ADD     A, A
    LD      D, 0
    LD      E, A
    LD      A, L
    LD      HL, SCREEN_ROWS
    ADD     HL, DE
    LD      E, A
    LD      A, (HL)
    INC     HL
    LD      H, (HL)
    LD      L, A
    ADD     HL, DE
RET

SHOW_CURSOR_OR_SPRITE:
    LD      A, (UNK_DC89)
    LD      B, A
    LD      A, (CURSOR_LEFT_BOUNDARY)
    LD      C, A
    LD      A, (KEYBOARD_READY_FLAG)
    OR      A
    JR      Z, CHECK_SPRITE_MODE
    LD      A, C
    ADD     A, B
    LD      E, A
    LD      A, L
    SUB     E
    JR      C, ADJUST_CURSOR_LEFT_BOUNDARY
    LD      A, C
    ADD     A, 1EH
    SUB     B
    SUB     L
    JR      C, ADJUST_CURSOR_RIGHT_BOUNDARY
CHECK_SPRITE_MODE:
    LD      A, (CURSOR_SPRITE_MODE)
    OR      A
    RET     Z
    LD      B, 1
    LD      A, C
    JP      M, FALLBACK_CURSOR_RENDER
    LD      HL, (FKEY_TEMP_OFFSET)
    LD      A, L
    SUB     C
    RET     C
    LD      E, A
    LD      D, 0
    CP      1EH
    RET     NC
CALCULATE_SPRITE_OFFSET:
    LD      L, H
    LD      H, D
    ADD     HL, HL
    ADD     HL, HL
    ADD     HL, HL
    ADD     HL, HL
    ADD     HL, HL
    ADD     HL, DE
    LD      DE, 1802H
    ADD     HL, DE
    LD      BC, (FKEY_TEMP_STORAGE)
    LD      A, (BC)
    LD      BC, 1
    EX      DE, HL
WRITE_CURSOR_SPRITE:
    JP      VRAM_FILL

ADJUST_CURSOR_RIGHT_BOUNDARY:
    NEG
    LD      E, 0
    LD      B, A
    LD      A, 32H
    SUB     C
    JR      Z, CHECK_SPRITE_MODE
    CP      B
    JR      NC, LOC_ED30
    LD      B, A
LOC_ED30:
    LD      A, C
    ADD     A, B
    INC     C
    JR      UPDATE_SCROLL_OFFSET
ADJUST_CURSOR_LEFT_BOUNDARY:
    NEG
    LD      E, 0FFH
    CP      C
    JR      C, LOC_ED3D
    LD      A, C
LOC_ED3D:
    LD      B, A
    LD      A, C
    OR      A
    JR      Z, CHECK_SPRITE_MODE
    SUB     B
    DEC     C
UPDATE_SCROLL_OFFSET:
    LD      (CURSOR_LEFT_BOUNDARY), A
    LD      HL, ACTIVE_DEVICE
    BIT     7, (HL)
    JR      Z, CHECK_CURSOR_LIMIT+1
    LD      B, 1
CHECK_CURSOR_LIMIT:
    CP      79H
    LD      C, E
FALLBACK_CURSOR_RENDER:
    LD      HL, ROW_00
    ADD     A, L
    LD      L, A
    JR      NC, CURSOR_RENDER_WRITE_BLOCK
    INC     H
    JR      CURSOR_RENDER_WRITE_BLOCK
CURSOR_RENDER_LOOP_Y:
    INC     C
    DEC     C
    JR      NZ, CURSOR_RENDER_LOOP_X+1
    INC     HL
CURSOR_RENDER_LOOP_X:
    CP      2BH ; '+'
CURSOR_RENDER_WRITE_BLOCK:
    PUSH    BC
    PUSH    HL
    LD      DE, 1802H
    LD      A, (FKEY_DEFAULT_RAM)
    LD      B, A
    INC     B
CURSOR_RENDER_LINE_LOOP:
    PUSH    BC
    LD      BC, 1EH
    PUSH    DE
    CALL    VRAM_WRITE
    EX      DE, HL
    POP     HL
    LD      BC, 20H
    ADD     HL, BC
    EX      DE, HL
    LD      BC, 32H
    ADD     HL, BC
    POP     BC
    DJNZ    CURSOR_RENDER_LINE_LOOP
    POP     HL
    POP     BC
    DJNZ    CURSOR_RENDER_LOOP_Y
RET

BEEP_SOUND:
    LD      A, 8FH
	OUT     (SOUND_PORT), A
    LD      A, 11H
	OUT     (SOUND_PORT), A
	LD      A, 90H
	OUT     (SOUND_PORT), A
    LD      BC, 780H
BEEP_DELAY_LOOP:
    EX      (SP), HL
    EX      (SP), HL
    DEC     BC
    LD      A, B
    OR      C
    JR      NZ, BEEP_DELAY_LOOP
    LD      A, 9FH
	OUT     (SOUND_PORT), A
RET

GET_FKEY_STATUS:
    LD      HL, (FKEY_STATUS)
RET

SET_FKEY_STATUS:
    LD      (FKEY_STATUS), HL
RET

FKEY_ADJUST_STACK:
    ADD     HL, SP
    DB 0DDH
FKEY_OPCODE_PREFIX:
    EXX
    CALL    C, FUNCTION_KEY_TEXT_A
    ADD     HL, SP
FKEY_TOGGLE_HANDLER:
    LD      IX, (FKEY_MACRO_PTR)
    LD      B, 6
FKEY_MACRO_LOOP:
    PUSH    BC
    PUSH    HL
    CALL    FKEY_STUFF_H
    POP     HL
    POP     BC
    INC     HL
    INC     HL
    INC     HL
    DJNZ    FKEY_MACRO_LOOP
FKEY_TOGGLE_HANDLER_END:
RET

FKEY_STUFF_H:
    LD      A, 6
    SUB     B
    LD      B, A
    LD      C, (HL)
    PUSH    BC
    CALL    CALC_TEXT_BLOCK_PTR
    POP     BC
    PUSH    BC
    CALL    FORMAT_TEXT_BLOCK
    POP     BC
    LD      D, 0
    LD      E, B
    LD      A, C
    AND     7FH
    EX      DE, HL
    CALL    CALC_VRAM_OFFSET
    LD      DE, 1000H
    ADD     HL, DE
    EX      DE, HL
    LD      H, 0
    LD      L, A
    ADD     HL, HL
    LD      B, H
    LD      C, L
    ADD     HL, HL
    ADD     HL, HL
    ADD     HL, BC
    LD      BC, (FKEY_STUFF_C)
    ADD     HL, BC
    PUSH    DE
    CALL    RENDER_TEXT_BLOCK
    EX      DE, HL
    POP     HL
    LD      BC, 400H
    ADD     HL, BC
    EX      DE, HL

RENDER_TEXT_BLOCK:
    LD      B, 5
LOC_EDFF:
    PUSH    BC
    PUSH    DE
    PUSH    HL
    LD      (WORD_FC20), SP
    LD      SP, WORD_FC20
    LD      A, (HL)
    AND     7FH
    LD      L, A
    LD      H, 0
    ADD     HL, HL
    ADD     HL, HL
    ADD     HL, HL
    XOR     A
	OUT     (MEM_PORT), A
    LD      BC, ($102)
    ADD     HL, BC
    LD      BC, 8
    CALL    VRAM_WRITE
    LD      A, 1
	OUT     (MEM_PORT), A
    LD      SP, (WORD_FC20)
    POP     DE
    POP     HL
    LD      BC, 8
    ADD     HL, BC
    EX      DE, HL
    INC     HL
    POP     BC
    DJNZ    LOC_EDFF
RET

CALC_VRAM_OFFSET:
    ADD     HL, HL
    ADD     HL, HL
    ADD     HL, HL
    LD      D, H
    LD      E, L
    ADD     HL, HL
    ADD     HL, HL
    ADD     HL, DE
RET

CALC_TEXT_BLOCK_PTR:
    LD      A, B
    ADD     A, A
    ADD     A, A
    ADD     A, B
    LD      B, 0
    BIT     7, C
    LD      C, A
    LD      HL, 1AA2H
    ADD     HL, BC
    EX      DE, HL
    JR      Z, LOC_EE50
    LD      BC, 1EH
LOC_EE50:
    LD      HL, FKEY_TEXT_BLOCKS
    ADD     HL, BC
    LD      BC, 5
    JP      VRAM_WRITE

FORMAT_TEXT_BLOCK:
    LD      H, 0
    LD      L, B
    CALL    CALC_VRAM_OFFSET
    LD      DE, 3000H
    ADD     HL, DE
    EX      DE, HL
    BIT     7, C
    JR      NZ, FILL_TEXT_PADDING+1
    LD      A, 0F4H
	RR      B
	CCF
    ADC     A, 0
FILL_TEXT_PADDING:
    LD      HL, 1A3EH
    LD      BC, 28H
    PUSH    DE
    CALL    VRAM_FILL
    POP     HL
    LD      BC, 400H
    ADD     HL, BC
    EX      DE, HL
    LD      BC, 28H
    JP      VRAM_FILL

BYTE_EE86:
	DB 0
OFF_EE87:
	DW UNK_FC22

AUX_IN_STATUS:
    LD      A, (BYTE_EE86)
    OR      A
    JR      NZ, LOC_EE9A
    CALL    CHECK_AUX_READY
	CCF
    JR      C, LOC_EE9A
    AND     3FH
    JR      NZ, LOC_EE9A
LOC_EE99:
    SCF
LOC_EE9A:
    LD      A, 0FFH
    ADC     A, 0
RET

AUX_OUT_STATUS:
    CALL    CHECK_AUX_READY
	CCF
    JR      C, LOC_EE9A
    RLCA
    JR      LOC_EE9A
AUX_READ:
    LD      A, (BYTE_EE86)
    OR      A
    JR      NZ, AUX_READ_FINALIZE
AUX_WAIT_LOOP:
    CALL    CHECK_AUX_READY
    JR      NC, LOC_EE99
    AND     3FH
    JR      Z, AUX_WAIT_LOOP
    LD      C, A
    LD      B, 0
AUX_BUFFER_FILL_LOOP:
    PUSH    BC
    LD      HL, UNK_FC22
    LD      (OFF_EE87), HL
    LD      A, 0EH
    CALL    AUX_WRITE_ALT_HANDLER
    POP     BC
    JR      NC, AUX_BUFFER_FILL_LOOP
    LD      A, C
AUX_READ_FINALIZE:
    DEC     A
    LD      (BYTE_EE86), A
    LD      HL, (OFF_EE87)
    LD      A, (HL)
    INC     HL
    LD      (OFF_EE87), HL
RET

INIT_AUX_DEVICE:
    LD      B, 6
LOC_EED9:
    LD      A, (HL)
    PUSH    BC
    PUSH    HL
    LD      HL, UNK_FC5E
    LD      (HL), A
    DEC     HL
    LD      A, 6
    SUB     B
    LD      (HL), A
AUX_WRITE_LOOP:
    LD      BC, 2
    LD      A, 0EH
    CALL    AUX_WRITE_HANDLER
    JR      C, AUX_WRITE_FAIL
    CP      6
    LD      HL, UNK_FC5D
    JR      Z, AUX_WRITE_LOOP
    POP     HL
    POP     BC
    JR      AUX_INIT_EXIT
AUX_WRITE_FAIL:
    POP     HL
    POP     BC
    INC     HL
    DJNZ    LOC_EED9
AUX_INIT_EXIT:
    LD      A, B
LOC_EF00:
    OR      A
RET

CHECK_AUX_READY:
    LD      A, 0EH
    CALL    DEBOUNCE_TIMING_CHECK
    RET     NC
WAIT_FOR_READY_BIT:
    LD      A, (HL)
    RLCA
    JR      NC, WAIT_FOR_READY_BIT
    LD      C, 21H
TIMEOUT_LOOP:
    DEC     C
    JR      Z, LOC_EF00
    LD      (HL), 1
WAIT_FOR_ACK:
    LD      A, (HL)
    XOR     80H
    JP      M, WAIT_FOR_ACK
    JR      NZ, TIMEOUT_LOOP
    LD      D, H
    LD      E, L
    LD      BC, 14H
    ADD     HL, BC
    LD      A, (HL)
    EX      DE, HL
    SCF
CHECK_AUX_READY_EXIT:
RET


    DB    0
    DB    0
    DB    0
    DB    0
    DB    0
    DB    0
    DB    0
    DB    0
    DB    0
    DB    0
    DB    0
    DB    0
    DB    0
    DB    0
    DB    0
    DB    0
    DB    0
    DB    0
    DB    0
    DB    0
    DB    0
    DB    0
    DB    0


 	ORG $EF3C

BUFFER_01:     DS $80
BUFFER_02:     DS $10
BUFFER_03:     DS $10
BUFFER_04:     DS $10
BUFFER_05:     DS $10
BUFFER_06:     DS $08
BUFFER_07:     DS $1E
BUFFER_08:     DS $1E
BUFFER_09:     DS $12
BUFFER_10:     DS $12
BUFFER_11:     DS $07

KEYBOARD_LATCH_STATUS_BYTE: DS 1
AUX_DEVICE_BUFFER_1:        DS 1
AUX_DEVICE_BUFFER_2:        DS 1
DRIVE_ORDER:                DS 1
CURRENT_DRIVE:              DS 1
CUR_MEDIA_SIGNNATURE:       DS 2
STORE_INIT_STATUS:          DS 1
MEDIA_SIGNATURE_WORD:       DS 2
MEDIA_LOOP_EXIT:            DS 2

MEDIA_SETUP_ROUTINE:
    PUSH    DE
    PUSH    HL
    LD      (WORD_FC20), SP
    LD      SP, WORD_FC20
    LD      A, (HL)
    AND     7FH
    LD      L, A
    LD      H, 0
    ADD     HL, HL
    ADD     HL, HL
    ADD     HL, HL
    XOR     A
	OUT     (MEM_PORT), A
    LD      BC, ($102)
    ADD     HL, BC
    LD      BC, 8
    CALL    VRAM_WRITE
    LD      A, 1
	OUT     (MEM_PORT), A
    LD      SP, (WORD_FC20)
    POP     DE
    POP     HL
    LD      BC, 8
    ADD     HL, BC
    EX      DE, HL
    INC     HL
    POP     BC
    DJNZ    MEDIA_LOOP_EXIT+1
RET
    ADD     HL, HL
    ADD     HL, HL
    ADD     HL, HL
    LD      D, H
    LD      E, L
    ADD     HL, HL
    ADD     HL, HL
    ADD     HL, DE
RET
    LD      A, B
    ADD     A, A
    ADD     A, A
    ADD     A, B
    LD      B, 0
    BIT     7, C
    LD      C, A
    LD      HL, 1AA2H
    ADD     HL, BC
    EX      DE, HL
    JR      Z, LOC_F0C7
    LD      BC, 1EH
LOC_F0C7:
    LD      HL, FKEY_TEXT_BLOCKS
    ADD     HL, BC
    LD      BC, 5
    JP      VRAM_WRITE
    LD      H, 0
    LD      L, B
    CALL    CALC_VRAM_OFFSET
    LD      DE, 3000H
    ADD     HL, DE
    EX      DE, HL
    BIT     7, C
    JR      NZ, LOC_F0E7+1
    LD      A, 0F4H
	RR      B
	CCF
    ADC     A, 0
LOC_F0E7:
    LD      HL, 1A3EH
    LD      BC, 28H
    PUSH    DE
    CALL    VRAM_FILL
    POP     HL
    LD      BC, 400H
    ADD     HL, BC
    EX      DE, HL
    LD      BC, 28H
    JP      VRAM_FILL
    NOP
    LD      ($3AFC), HL
    ADD     A, (HL)
    XOR     0B7H
    JR      NZ, AUX_INPUT_EXIT
    CALL    CHECK_AUX_READY
	CCF
    JR      C, AUX_INPUT_EXIT
    AND     3FH
    JR      NZ, AUX_INPUT_EXIT
SET_CARRY_FLAG:
    SCF
AUX_INPUT_EXIT:
    LD      A, 0FFH
    ADC     A, 0
RET

    CALL    CHECK_AUX_READY
	CCF
    JR      C, AUX_INPUT_EXIT
    RLCA
    JR      AUX_INPUT_EXIT
    LD      A, (BYTE_EE86)
    OR      A
    JR      NZ, LOC_F141
AUX_WAIT_FOR_INPUT:
    CALL    CHECK_AUX_READY
    JR      NC, SET_CARRY_FLAG
    AND     3FH
    JR      Z, AUX_WAIT_FOR_INPUT
    LD      C, A
    LD      B, 0
LOC_F131:
    PUSH    BC
    LD      HL, UNK_FC22
    LD      (OFF_EE87), HL
    LD      A, 0EH
    CALL    AUX_WRITE_ALT_HANDLER
    POP     BC
    JR      NC, LOC_F131
    LD      A, C
LOC_F141:
    DEC     A
    LD      (BYTE_EE86), A
    LD      HL, (OFF_EE87)
    LD      A, (HL)
    INC     HL
    LD      (OFF_EE87), HL
RET

    LD      B, 6
LOC_F150:
    LD      A, (HL)
    PUSH    BC
    PUSH    HL
    LD      HL, UNK_FC5E
    LD      (HL), A
    DEC     HL
    LD      A, 6
    SUB     B
    LD      (HL), A
AUX_WRITE_RETRY_LOOP:
    LD      BC, 2
    LD      A, 0EH
    CALL    AUX_WRITE_HANDLER
    JR      C, AUX_WRITE_FAIL_HANDLER
    CP      6
    LD      HL, UNK_FC5D
    JR      Z, AUX_WRITE_RETRY_LOOP
    POP     HL
    POP     BC
    JR      _AUX_INIT_EXIT
AUX_WRITE_FAIL_HANDLER:
    POP     HL
    POP     BC
    INC     HL
    DJNZ    LOC_F150
_AUX_INIT_EXIT:
    LD      A, B
LOC_F177:
    OR      A
RET

    LD      A, 0EH
    CALL    DEBOUNCE_TIMING_CHECK
	RET     NC
_WAIT_FOR_READY_BIT:
    LD      A, (HL)
    RLCA
    JR      NC, _WAIT_FOR_READY_BIT
    LD      C, 21H
_TIMEOUT_LOOP:
    DEC     C
    JR      Z, LOC_F177
    LD      (HL), 1
    LD      A, (HL)
    XOR     80H
    JP      M, WAIT_FOR_ACK
    JR      NZ, _TIMEOUT_LOOP
    LD      D, H
    LD      E, L
    LD      BC, 14H
    ADD     HL, BC
    LD      A, (HL)
    EX      DE, HL
    SCF
RET
    DB    0
    DB    0
    DB    0
    DB    0
    DB    0
    DB    0
    DB    0
    DB    0
    DB    0
    DB    0
    DB    0
    DB    0
    DB    0
    DB    0
    DB    0
    DB    0
    DB    0
    DB    0
    DB    0
    DB    0
    DB    0
    DB    0
    DB    0
    DB    0
    DB    0
    DB    0
    DB    0
    DB    0
    DB    0
    DB    0
    DB    0
    DB    0
    DB    0
    DB    0
    DB    0
    DB    0
    DB    0
    DB    0
    DB    0
    DB    0
    DB    0
    DB    0
    DB    0
    DB    0
    DB    0
    DB    0
    DB    0
    DB    0
    DB    0
    DB    0
    DB    0
    DB    0
    DB    0
    DB    0
    DB    0
    DB    0
    DB    0
    DB    0
    DB    0
    DB    0
    DB    0
    DB    0
    DB    0
    DB    0
    DB    0
    DB    0
    DB    0
    DB    0
    DB    0
    DB    0
    DB    0
    DB    0
    DB    0
    DB    0
    DB    0
    DB    0
    DB    0
    DB    0
    DB    0
    DB    0
    DB    0
    DB    0
    DB    0
    DB    0
    DB    0
    DB    0
    DB    0
    DB    0
    DB    0
    DB    0
    DB    0
    DB    0
    DB    0
    DB    0
    DB    0
    DB    0
    DB    0
    DB    0
    DB    0
    DB    0